package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ModifyCurrentDbClusterCapacityRequest(
    dbClusterIdentifier: String,
    capacity: Optional[IntegerOptional] = Optional.Absent,
    secondsBeforeTimeout: Optional[IntegerOptional] = Optional.Absent,
    timeoutAction: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest = {
    import ModifyCurrentDbClusterCapacityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(capacity.map(value => value: Integer))(_.capacity)
      .optionallyWith(secondsBeforeTimeout.map(value => value: Integer))(
        _.secondsBeforeTimeout
      )
      .optionallyWith(timeoutAction.map(value => value: java.lang.String))(
        _.timeoutAction
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.ModifyCurrentDbClusterCapacityRequest.ReadOnly =
    zio.aws.rds.model.ModifyCurrentDbClusterCapacityRequest
      .wrap(buildAwsValue())
}
object ModifyCurrentDbClusterCapacityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyCurrentDbClusterCapacityRequest =
      zio.aws.rds.model.ModifyCurrentDbClusterCapacityRequest(
        dbClusterIdentifier,
        capacity.map(value => value),
        secondsBeforeTimeout.map(value => value),
        timeoutAction.map(value => value)
      )
    def dbClusterIdentifier: String
    def capacity: Optional[IntegerOptional]
    def secondsBeforeTimeout: Optional[IntegerOptional]
    def timeoutAction: Optional[String]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getCapacity: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getSecondsBeforeTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("secondsBeforeTimeout", secondsBeforeTimeout)
    def getTimeoutAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timeoutAction", timeoutAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest
  ) extends zio.aws.rds.model.ModifyCurrentDbClusterCapacityRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val capacity: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.capacity())
      .map(value => value: IntegerOptional)
    override val secondsBeforeTimeout: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondsBeforeTimeout())
        .map(value => value: IntegerOptional)
    override val timeoutAction: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.timeoutAction())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest
  ): zio.aws.rds.model.ModifyCurrentDbClusterCapacityRequest.ReadOnly =
    new Wrapper(impl)
}
