package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{
  AwsBackupRecoveryPointArn,
  BooleanOptional,
  IntegerOptional
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ModifyDbInstanceRequest(
    dbInstanceIdentifier: String,
    allocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    dbInstanceClass: Optional[String] = Optional.Absent,
    dbSubnetGroupName: Optional[String] = Optional.Absent,
    dbSecurityGroups: Optional[Iterable[String]] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    applyImmediately: Optional[Boolean] = Optional.Absent,
    masterUserPassword: Optional[String] = Optional.Absent,
    dbParameterGroupName: Optional[String] = Optional.Absent,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    preferredBackupWindow: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    multiAZ: Optional[BooleanOptional] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    allowMajorVersionUpgrade: Optional[Boolean] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    licenseModel: Optional[String] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    optionGroupName: Optional[String] = Optional.Absent,
    newDBInstanceIdentifier: Optional[String] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    tdeCredentialArn: Optional[String] = Optional.Absent,
    tdeCredentialPassword: Optional[String] = Optional.Absent,
    caCertificateIdentifier: Optional[String] = Optional.Absent,
    domain: Optional[String] = Optional.Absent,
    copyTagsToSnapshot: Optional[BooleanOptional] = Optional.Absent,
    monitoringInterval: Optional[IntegerOptional] = Optional.Absent,
    dbPortNumber: Optional[IntegerOptional] = Optional.Absent,
    publiclyAccessible: Optional[BooleanOptional] = Optional.Absent,
    monitoringRoleArn: Optional[String] = Optional.Absent,
    domainIAMRoleName: Optional[String] = Optional.Absent,
    promotionTier: Optional[IntegerOptional] = Optional.Absent,
    enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      Optional.Absent,
    enablePerformanceInsights: Optional[BooleanOptional] = Optional.Absent,
    performanceInsightsKMSKeyId: Optional[String] = Optional.Absent,
    performanceInsightsRetentionPeriod: Optional[IntegerOptional] =
      Optional.Absent,
    cloudwatchLogsExportConfiguration: Optional[
      zio.aws.rds.model.CloudwatchLogsExportConfiguration
    ] = Optional.Absent,
    processorFeatures: Optional[Iterable[zio.aws.rds.model.ProcessorFeature]] =
      Optional.Absent,
    useDefaultProcessorFeatures: Optional[BooleanOptional] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    maxAllocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    certificateRotationRestart: Optional[BooleanOptional] = Optional.Absent,
    replicaMode: Optional[zio.aws.rds.model.ReplicaMode] = Optional.Absent,
    enableCustomerOwnedIp: Optional[BooleanOptional] = Optional.Absent,
    awsBackupRecoveryPointArn: Optional[AwsBackupRecoveryPointArn] =
      Optional.Absent,
    automationMode: Optional[zio.aws.rds.model.AutomationMode] =
      Optional.Absent,
    resumeFullAutomationModeMinutes: Optional[IntegerOptional] =
      Optional.Absent,
    networkType: Optional[String] = Optional.Absent,
    storageThroughput: Optional[IntegerOptional] = Optional.Absent,
    manageMasterUserPassword: Optional[BooleanOptional] = Optional.Absent,
    rotateMasterUserPassword: Optional[BooleanOptional] = Optional.Absent,
    masterUserSecretKmsKeyId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest = {
    import ModifyDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        dbSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dbSecurityGroups)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(
        dbParameterGroupName.map(value => value: java.lang.String)
      )(_.dbParameterGroupName)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        allowMajorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowMajorVersionUpgrade)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        newDBInstanceIdentifier.map(value => value: java.lang.String)
      )(_.newDBInstanceIdentifier)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(
        _.tdeCredentialArn
      )
      .optionallyWith(
        tdeCredentialPassword.map(value => value: java.lang.String)
      )(_.tdeCredentialPassword)
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(monitoringInterval.map(value => value: Integer))(
        _.monitoringInterval
      )
      .optionallyWith(dbPortNumber.map(value => value: Integer))(_.dbPortNumber)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(
        _.monitoringRoleArn
      )
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .optionallyWith(promotionTier.map(value => value: Integer))(
        _.promotionTier
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(
        enablePerformanceInsights.map(value => value: java.lang.Boolean)
      )(_.enablePerformanceInsights)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .optionallyWith(
        performanceInsightsRetentionPeriod.map(value => value: Integer)
      )(_.performanceInsightsRetentionPeriod)
      .optionallyWith(
        cloudwatchLogsExportConfiguration.map(value => value.buildAwsValue())
      )(_.cloudwatchLogsExportConfiguration)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(
        useDefaultProcessorFeatures.map(value => value: java.lang.Boolean)
      )(_.useDefaultProcessorFeatures)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(maxAllocatedStorage.map(value => value: Integer))(
        _.maxAllocatedStorage
      )
      .optionallyWith(
        certificateRotationRestart.map(value => value: java.lang.Boolean)
      )(_.certificateRotationRestart)
      .optionallyWith(replicaMode.map(value => value.unwrap))(_.replicaMode)
      .optionallyWith(
        enableCustomerOwnedIp.map(value => value: java.lang.Boolean)
      )(_.enableCustomerOwnedIp)
      .optionallyWith(
        awsBackupRecoveryPointArn.map(value =>
          AwsBackupRecoveryPointArn.unwrap(value): java.lang.String
        )
      )(_.awsBackupRecoveryPointArn)
      .optionallyWith(automationMode.map(value => value.unwrap))(
        _.automationMode
      )
      .optionallyWith(
        resumeFullAutomationModeMinutes.map(value => value: Integer)
      )(_.resumeFullAutomationModeMinutes)
      .optionallyWith(networkType.map(value => value: java.lang.String))(
        _.networkType
      )
      .optionallyWith(storageThroughput.map(value => value: Integer))(
        _.storageThroughput
      )
      .optionallyWith(
        manageMasterUserPassword.map(value => value: java.lang.Boolean)
      )(_.manageMasterUserPassword)
      .optionallyWith(
        rotateMasterUserPassword.map(value => value: java.lang.Boolean)
      )(_.rotateMasterUserPassword)
      .optionallyWith(
        masterUserSecretKmsKeyId.map(value => value: java.lang.String)
      )(_.masterUserSecretKmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbInstanceRequest.ReadOnly =
    zio.aws.rds.model.ModifyDbInstanceRequest.wrap(buildAwsValue())
}
object ModifyDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbInstanceRequest =
      zio.aws.rds.model.ModifyDbInstanceRequest(
        dbInstanceIdentifier,
        allocatedStorage.map(value => value),
        dbInstanceClass.map(value => value),
        dbSubnetGroupName.map(value => value),
        dbSecurityGroups.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        applyImmediately.map(value => value),
        masterUserPassword.map(value => value),
        dbParameterGroupName.map(value => value),
        backupRetentionPeriod.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        allowMajorVersionUpgrade.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        licenseModel.map(value => value),
        iops.map(value => value),
        optionGroupName.map(value => value),
        newDBInstanceIdentifier.map(value => value),
        storageType.map(value => value),
        tdeCredentialArn.map(value => value),
        tdeCredentialPassword.map(value => value),
        caCertificateIdentifier.map(value => value),
        domain.map(value => value),
        copyTagsToSnapshot.map(value => value),
        monitoringInterval.map(value => value),
        dbPortNumber.map(value => value),
        publiclyAccessible.map(value => value),
        monitoringRoleArn.map(value => value),
        domainIAMRoleName.map(value => value),
        promotionTier.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        enablePerformanceInsights.map(value => value),
        performanceInsightsKMSKeyId.map(value => value),
        performanceInsightsRetentionPeriod.map(value => value),
        cloudwatchLogsExportConfiguration.map(value => value.asEditable),
        processorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        useDefaultProcessorFeatures.map(value => value),
        deletionProtection.map(value => value),
        maxAllocatedStorage.map(value => value),
        certificateRotationRestart.map(value => value),
        replicaMode.map(value => value),
        enableCustomerOwnedIp.map(value => value),
        awsBackupRecoveryPointArn.map(value => value),
        automationMode.map(value => value),
        resumeFullAutomationModeMinutes.map(value => value),
        networkType.map(value => value),
        storageThroughput.map(value => value),
        manageMasterUserPassword.map(value => value),
        rotateMasterUserPassword.map(value => value),
        masterUserSecretKmsKeyId.map(value => value)
      )
    def dbInstanceIdentifier: String
    def allocatedStorage: Optional[IntegerOptional]
    def dbInstanceClass: Optional[String]
    def dbSubnetGroupName: Optional[String]
    def dbSecurityGroups: Optional[List[String]]
    def vpcSecurityGroupIds: Optional[List[String]]
    def applyImmediately: Optional[Boolean]
    def masterUserPassword: Optional[String]
    def dbParameterGroupName: Optional[String]
    def backupRetentionPeriod: Optional[IntegerOptional]
    def preferredBackupWindow: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def multiAZ: Optional[BooleanOptional]
    def engineVersion: Optional[String]
    def allowMajorVersionUpgrade: Optional[Boolean]
    def autoMinorVersionUpgrade: Optional[BooleanOptional]
    def licenseModel: Optional[String]
    def iops: Optional[IntegerOptional]
    def optionGroupName: Optional[String]
    def newDBInstanceIdentifier: Optional[String]
    def storageType: Optional[String]
    def tdeCredentialArn: Optional[String]
    def tdeCredentialPassword: Optional[String]
    def caCertificateIdentifier: Optional[String]
    def domain: Optional[String]
    def copyTagsToSnapshot: Optional[BooleanOptional]
    def monitoringInterval: Optional[IntegerOptional]
    def dbPortNumber: Optional[IntegerOptional]
    def publiclyAccessible: Optional[BooleanOptional]
    def monitoringRoleArn: Optional[String]
    def domainIAMRoleName: Optional[String]
    def promotionTier: Optional[IntegerOptional]
    def enableIAMDatabaseAuthentication: Optional[BooleanOptional]
    def enablePerformanceInsights: Optional[BooleanOptional]
    def performanceInsightsKMSKeyId: Optional[String]
    def performanceInsightsRetentionPeriod: Optional[IntegerOptional]
    def cloudwatchLogsExportConfiguration
        : Optional[zio.aws.rds.model.CloudwatchLogsExportConfiguration.ReadOnly]
    def processorFeatures
        : Optional[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]]
    def useDefaultProcessorFeatures: Optional[BooleanOptional]
    def deletionProtection: Optional[BooleanOptional]
    def maxAllocatedStorage: Optional[IntegerOptional]
    def certificateRotationRestart: Optional[BooleanOptional]
    def replicaMode: Optional[zio.aws.rds.model.ReplicaMode]
    def enableCustomerOwnedIp: Optional[BooleanOptional]
    def awsBackupRecoveryPointArn: Optional[AwsBackupRecoveryPointArn]
    def automationMode: Optional[zio.aws.rds.model.AutomationMode]
    def resumeFullAutomationModeMinutes: Optional[IntegerOptional]
    def networkType: Optional[String]
    def storageThroughput: Optional[IntegerOptional]
    def manageMasterUserPassword: Optional[BooleanOptional]
    def rotateMasterUserPassword: Optional[BooleanOptional]
    def masterUserSecretKmsKeyId: Optional[String]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getDbSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dbSecurityGroups", dbSecurityGroups)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getDbParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupName)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAllowMajorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("allowMajorVersionUpgrade", allowMajorVersionUpgrade)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getNewDBInstanceIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("newDBInstanceIdentifier", newDBInstanceIdentifier)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getTdeCredentialArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArn)
    def getTdeCredentialPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialPassword", tdeCredentialPassword)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getMonitoringInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getDbPortNumber: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("dbPortNumber", dbPortNumber)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getMonitoringRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
    def getPromotionTier: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getEnablePerformanceInsights: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enablePerformanceInsights",
        enablePerformanceInsights
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
    def getPerformanceInsightsRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "performanceInsightsRetentionPeriod",
      performanceInsightsRetentionPeriod
    )
    def getCloudwatchLogsExportConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.CloudwatchLogsExportConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudwatchLogsExportConfiguration",
      cloudwatchLogsExportConfiguration
    )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getUseDefaultProcessorFeatures: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "useDefaultProcessorFeatures",
        useDefaultProcessorFeatures
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getMaxAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorage)
    def getCertificateRotationRestart: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "certificateRotationRestart",
        certificateRotationRestart
      )
    def getReplicaMode: ZIO[Any, AwsError, zio.aws.rds.model.ReplicaMode] =
      AwsError.unwrapOptionField("replicaMode", replicaMode)
    def getEnableCustomerOwnedIp: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enableCustomerOwnedIp", enableCustomerOwnedIp)
    def getAwsBackupRecoveryPointArn
        : ZIO[Any, AwsError, AwsBackupRecoveryPointArn] = AwsError
      .unwrapOptionField("awsBackupRecoveryPointArn", awsBackupRecoveryPointArn)
    def getAutomationMode
        : ZIO[Any, AwsError, zio.aws.rds.model.AutomationMode] =
      AwsError.unwrapOptionField("automationMode", automationMode)
    def getResumeFullAutomationModeMinutes
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "resumeFullAutomationModeMinutes",
      resumeFullAutomationModeMinutes
    )
    def getNetworkType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkType", networkType)
    def getStorageThroughput: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("storageThroughput", storageThroughput)
    def getManageMasterUserPassword: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "manageMasterUserPassword",
        manageMasterUserPassword
      )
    def getRotateMasterUserPassword: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "rotateMasterUserPassword",
        rotateMasterUserPassword
      )
    def getMasterUserSecretKmsKeyId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("masterUserSecretKmsKeyId", masterUserSecretKmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest
  ) extends zio.aws.rds.model.ModifyDbInstanceRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val allocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocatedStorage())
        .map(value => value: IntegerOptional)
    override val dbInstanceClass: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceClass())
      .map(value => value: String)
    override val dbSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroupName())
      .map(value => value: String)
    override val dbSecurityGroups: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val applyImmediately: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.applyImmediately())
      .map(value => value: Boolean)
    override val masterUserPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserPassword())
      .map(value => value: String)
    override val dbParameterGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbParameterGroupName())
      .map(value => value: String)
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val preferredBackupWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredBackupWindow())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val multiAZ: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: BooleanOptional)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val allowMajorVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowMajorVersionUpgrade())
        .map(value => value: Boolean)
    override val autoMinorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val licenseModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => value: String)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val newDBInstanceIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newDBInstanceIdentifier())
        .map(value => value: String)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val tdeCredentialArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tdeCredentialArn())
      .map(value => value: String)
    override val tdeCredentialPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tdeCredentialPassword())
      .map(value => value: String)
    override val caCertificateIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caCertificateIdentifier())
        .map(value => value: String)
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val copyTagsToSnapshot: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyTagsToSnapshot())
        .map(value => value: BooleanOptional)
    override val monitoringInterval: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringInterval())
        .map(value => value: IntegerOptional)
    override val dbPortNumber: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.dbPortNumber())
      .map(value => value: IntegerOptional)
    override val publiclyAccessible: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publiclyAccessible())
        .map(value => value: BooleanOptional)
    override val monitoringRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringRoleArn())
      .map(value => value: String)
    override val domainIAMRoleName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainIAMRoleName())
      .map(value => value: String)
    override val promotionTier: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.promotionTier())
        .map(value => value: IntegerOptional)
    override val enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableIAMDatabaseAuthentication())
        .map(value => value: BooleanOptional)
    override val enablePerformanceInsights: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePerformanceInsights())
        .map(value => value: BooleanOptional)
    override val performanceInsightsKMSKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsKMSKeyId())
        .map(value => value: String)
    override val performanceInsightsRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val cloudwatchLogsExportConfiguration: Optional[
      zio.aws.rds.model.CloudwatchLogsExportConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudwatchLogsExportConfiguration())
      .map(value =>
        zio.aws.rds.model.CloudwatchLogsExportConfiguration.wrap(value)
      )
    override val processorFeatures
        : Optional[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processorFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ProcessorFeature.wrap(item)
          }.toList
        )
    override val useDefaultProcessorFeatures: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useDefaultProcessorFeatures())
        .map(value => value: BooleanOptional)
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val maxAllocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxAllocatedStorage())
        .map(value => value: IntegerOptional)
    override val certificateRotationRestart: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateRotationRestart())
        .map(value => value: BooleanOptional)
    override val replicaMode: Optional[zio.aws.rds.model.ReplicaMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaMode())
        .map(value => zio.aws.rds.model.ReplicaMode.wrap(value))
    override val enableCustomerOwnedIp: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCustomerOwnedIp())
        .map(value => value: BooleanOptional)
    override val awsBackupRecoveryPointArn
        : Optional[AwsBackupRecoveryPointArn] = zio.aws.core.internal
      .optionalFromNullable(impl.awsBackupRecoveryPointArn())
      .map(value =>
        zio.aws.rds.model.primitives.AwsBackupRecoveryPointArn(value)
      )
    override val automationMode: Optional[zio.aws.rds.model.AutomationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automationMode())
        .map(value => zio.aws.rds.model.AutomationMode.wrap(value))
    override val resumeFullAutomationModeMinutes: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resumeFullAutomationModeMinutes())
        .map(value => value: IntegerOptional)
    override val networkType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkType())
      .map(value => value: String)
    override val storageThroughput: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageThroughput())
        .map(value => value: IntegerOptional)
    override val manageMasterUserPassword: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manageMasterUserPassword())
        .map(value => value: BooleanOptional)
    override val rotateMasterUserPassword: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rotateMasterUserPassword())
        .map(value => value: BooleanOptional)
    override val masterUserSecretKmsKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUserSecretKmsKeyId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest
  ): zio.aws.rds.model.ModifyDbInstanceRequest.ReadOnly = new Wrapper(impl)
}
