package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyDbProxyTargetGroupRequest(
    targetGroupName: String,
    dbProxyName: String,
    connectionPoolConfig: Optional[
      zio.aws.rds.model.ConnectionPoolConfiguration
    ] = Optional.Absent,
    newName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupRequest = {
    import ModifyDbProxyTargetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupRequest
      .builder()
      .targetGroupName(targetGroupName: java.lang.String)
      .dbProxyName(dbProxyName: java.lang.String)
      .optionallyWith(connectionPoolConfig.map(value => value.buildAwsValue()))(
        _.connectionPoolConfig
      )
      .optionallyWith(newName.map(value => value: java.lang.String))(_.newName)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbProxyTargetGroupRequest.ReadOnly =
    zio.aws.rds.model.ModifyDbProxyTargetGroupRequest.wrap(buildAwsValue())
}
object ModifyDbProxyTargetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbProxyTargetGroupRequest =
      zio.aws.rds.model.ModifyDbProxyTargetGroupRequest(
        targetGroupName,
        dbProxyName,
        connectionPoolConfig.map(value => value.asEditable),
        newName.map(value => value)
      )
    def targetGroupName: String
    def dbProxyName: String
    def connectionPoolConfig
        : Optional[zio.aws.rds.model.ConnectionPoolConfiguration.ReadOnly]
    def newName: Optional[String]
    def getTargetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetGroupName)
    def getDbProxyName: ZIO[Any, Nothing, String] = ZIO.succeed(dbProxyName)
    def getConnectionPoolConfig: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.ConnectionPoolConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("connectionPoolConfig", connectionPoolConfig)
    def getNewName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("newName", newName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupRequest
  ) extends zio.aws.rds.model.ModifyDbProxyTargetGroupRequest.ReadOnly {
    override val targetGroupName: String = impl.targetGroupName(): String
    override val dbProxyName: String = impl.dbProxyName(): String
    override val connectionPoolConfig
        : Optional[zio.aws.rds.model.ConnectionPoolConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionPoolConfig())
        .map(value => zio.aws.rds.model.ConnectionPoolConfiguration.wrap(value))
    override val newName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.newName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupRequest
  ): zio.aws.rds.model.ModifyDbProxyTargetGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
