package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyGlobalClusterRequest(
    globalClusterIdentifier: Optional[String] = Optional.Absent,
    newGlobalClusterIdentifier: Optional[String] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    allowMajorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest = {
    import ModifyGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest
      .builder()
      .optionallyWith(
        globalClusterIdentifier.map(value => value: java.lang.String)
      )(_.globalClusterIdentifier)
      .optionallyWith(
        newGlobalClusterIdentifier.map(value => value: java.lang.String)
      )(_.newGlobalClusterIdentifier)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        allowMajorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowMajorVersionUpgrade)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyGlobalClusterRequest.ReadOnly =
    zio.aws.rds.model.ModifyGlobalClusterRequest.wrap(buildAwsValue())
}
object ModifyGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyGlobalClusterRequest =
      zio.aws.rds.model.ModifyGlobalClusterRequest(
        globalClusterIdentifier.map(value => value),
        newGlobalClusterIdentifier.map(value => value),
        deletionProtection.map(value => value),
        engineVersion.map(value => value),
        allowMajorVersionUpgrade.map(value => value)
      )
    def globalClusterIdentifier: Optional[String]
    def newGlobalClusterIdentifier: Optional[String]
    def deletionProtection: Optional[BooleanOptional]
    def engineVersion: Optional[String]
    def allowMajorVersionUpgrade: Optional[BooleanOptional]
    def getGlobalClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalClusterIdentifier", globalClusterIdentifier)
    def getNewGlobalClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "newGlobalClusterIdentifier",
        newGlobalClusterIdentifier
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAllowMajorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "allowMajorVersionUpgrade",
        allowMajorVersionUpgrade
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest
  ) extends zio.aws.rds.model.ModifyGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalClusterIdentifier())
        .map(value => value: String)
    override val newGlobalClusterIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newGlobalClusterIdentifier())
        .map(value => value: String)
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val allowMajorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowMajorVersionUpgrade())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest
  ): zio.aws.rds.model.ModifyGlobalClusterRequest.ReadOnly = new Wrapper(impl)
}
