package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Option(
    optionName: Optional[String] = Optional.Absent,
    optionDescription: Optional[String] = Optional.Absent,
    persistent: Optional[Boolean] = Optional.Absent,
    permanent: Optional[Boolean] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    optionVersion: Optional[String] = Optional.Absent,
    optionSettings: Optional[Iterable[zio.aws.rds.model.OptionSetting]] =
      Optional.Absent,
    dbSecurityGroupMemberships: Optional[
      Iterable[zio.aws.rds.model.DBSecurityGroupMembership]
    ] = Optional.Absent,
    vpcSecurityGroupMemberships: Optional[
      Iterable[zio.aws.rds.model.VpcSecurityGroupMembership]
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.Option = {
    import Option.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.Option
      .builder()
      .optionallyWith(optionName.map(value => value: java.lang.String))(
        _.optionName
      )
      .optionallyWith(optionDescription.map(value => value: java.lang.String))(
        _.optionDescription
      )
      .optionallyWith(persistent.map(value => value: java.lang.Boolean))(
        _.persistent
      )
      .optionallyWith(permanent.map(value => value: java.lang.Boolean))(
        _.permanent
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(optionVersion.map(value => value: java.lang.String))(
        _.optionVersion
      )
      .optionallyWith(
        optionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionSettings)
      .optionallyWith(
        dbSecurityGroupMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbSecurityGroupMemberships)
      .optionallyWith(
        vpcSecurityGroupMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupMemberships)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.Option.ReadOnly =
    zio.aws.rds.model.Option.wrap(buildAwsValue())
}
object Option {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.Option] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.Option = zio.aws.rds.model.Option(
      optionName.map(value => value),
      optionDescription.map(value => value),
      persistent.map(value => value),
      permanent.map(value => value),
      port.map(value => value),
      optionVersion.map(value => value),
      optionSettings.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      dbSecurityGroupMemberships.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      vpcSecurityGroupMemberships.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def optionName: Optional[String]
    def optionDescription: Optional[String]
    def persistent: Optional[Boolean]
    def permanent: Optional[Boolean]
    def port: Optional[IntegerOptional]
    def optionVersion: Optional[String]
    def optionSettings: Optional[List[zio.aws.rds.model.OptionSetting.ReadOnly]]
    def dbSecurityGroupMemberships
        : Optional[List[zio.aws.rds.model.DBSecurityGroupMembership.ReadOnly]]
    def vpcSecurityGroupMemberships
        : Optional[List[zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly]]
    def getOptionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionName", optionName)
    def getOptionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionDescription", optionDescription)
    def getPersistent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("persistent", persistent)
    def getPermanent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("permanent", permanent)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getOptionVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionVersion", optionVersion)
    def getOptionSettings
        : ZIO[Any, AwsError, List[zio.aws.rds.model.OptionSetting.ReadOnly]] =
      AwsError.unwrapOptionField("optionSettings", optionSettings)
    def getDbSecurityGroupMemberships: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbSecurityGroupMemberships",
      dbSecurityGroupMemberships
    )
    def getVpcSecurityGroupMemberships: ZIO[Any, AwsError, List[
      zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "vpcSecurityGroupMemberships",
      vpcSecurityGroupMemberships
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.Option
  ) extends zio.aws.rds.model.Option.ReadOnly {
    override val optionName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionName())
      .map(value => value: String)
    override val optionDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionDescription())
      .map(value => value: String)
    override val persistent: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.persistent())
      .map(value => value: Boolean)
    override val permanent: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.permanent())
      .map(value => value: Boolean)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val optionVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionVersion())
      .map(value => value: String)
    override val optionSettings
        : Optional[List[zio.aws.rds.model.OptionSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optionSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.OptionSetting.wrap(item)
          }.toList
        )
    override val dbSecurityGroupMemberships
        : Optional[List[zio.aws.rds.model.DBSecurityGroupMembership.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSecurityGroupMemberships())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBSecurityGroupMembership.wrap(item)
          }.toList
        )
    override val vpcSecurityGroupMemberships: Optional[
      List[zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSecurityGroupMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.Option
  ): zio.aws.rds.model.Option.ReadOnly = new Wrapper(impl)
}
