package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Outpost(arn: Optional[String] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.Outpost = {
    import Outpost.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.Outpost
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.Outpost.ReadOnly =
    zio.aws.rds.model.Outpost.wrap(buildAwsValue())
}
object Outpost {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.Outpost] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.Outpost =
      zio.aws.rds.model.Outpost(arn.map(value => value))
    def arn: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.Outpost
  ) extends zio.aws.rds.model.Outpost.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.Outpost
  ): zio.aws.rds.model.Outpost.ReadOnly = new Wrapper(impl)
}
