package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResetDbParameterGroupResponse(
    dbParameterGroupName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ResetDbParameterGroupResponse = {
    import ResetDbParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ResetDbParameterGroupResponse
      .builder()
      .optionallyWith(
        dbParameterGroupName.map(value => value: java.lang.String)
      )(_.dbParameterGroupName)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ResetDbParameterGroupResponse.ReadOnly =
    zio.aws.rds.model.ResetDbParameterGroupResponse.wrap(buildAwsValue())
}
object ResetDbParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ResetDbParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ResetDbParameterGroupResponse =
      zio.aws.rds.model
        .ResetDbParameterGroupResponse(dbParameterGroupName.map(value => value))
    def dbParameterGroupName: Optional[String]
    def getDbParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ResetDbParameterGroupResponse
  ) extends zio.aws.rds.model.ResetDbParameterGroupResponse.ReadOnly {
    override val dbParameterGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbParameterGroupName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ResetDbParameterGroupResponse
  ): zio.aws.rds.model.ResetDbParameterGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
