package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreDbClusterFromS3Response(
    dbCluster: Optional[zio.aws.rds.model.DBCluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Response = {
    import RestoreDbClusterFromS3Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Response
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RestoreDbClusterFromS3Response.ReadOnly =
    zio.aws.rds.model.RestoreDbClusterFromS3Response.wrap(buildAwsValue())
}
object RestoreDbClusterFromS3Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreDbClusterFromS3Response =
      zio.aws.rds.model.RestoreDbClusterFromS3Response(
        dbCluster.map(value => value.asEditable)
      )
    def dbCluster: Optional[zio.aws.rds.model.DBCluster.ReadOnly]
    def getDbCluster: ZIO[Any, AwsError, zio.aws.rds.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Response
  ) extends zio.aws.rds.model.RestoreDbClusterFromS3Response.ReadOnly {
    override val dbCluster: Optional[zio.aws.rds.model.DBCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbCluster())
        .map(value => zio.aws.rds.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Response
  ): zio.aws.rds.model.RestoreDbClusterFromS3Response.ReadOnly = new Wrapper(
    impl
  )
}
