package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreDbClusterFromSnapshotResponse(
    dbCluster: Optional[zio.aws.rds.model.DBCluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotResponse = {
    import RestoreDbClusterFromSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse.ReadOnly =
    zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse.wrap(buildAwsValue())
}
object RestoreDbClusterFromSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse =
      zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse(
        dbCluster.map(value => value.asEditable)
      )
    def dbCluster: Optional[zio.aws.rds.model.DBCluster.ReadOnly]
    def getDbCluster: ZIO[Any, AwsError, zio.aws.rds.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotResponse
  ) extends zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse.ReadOnly {
    override val dbCluster: Optional[zio.aws.rds.model.DBCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbCluster())
        .map(value => zio.aws.rds.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotResponse
  ): zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
