package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{BooleanOptional, IntegerOptional, TStamp}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RestoreDbInstanceToPointInTimeRequest(
    sourceDBInstanceIdentifier: Optional[String] = Optional.Absent,
    targetDBInstanceIdentifier: String,
    restoreTime: Optional[TStamp] = Optional.Absent,
    useLatestRestorableTime: Optional[Boolean] = Optional.Absent,
    dbInstanceClass: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    dbSubnetGroupName: Optional[String] = Optional.Absent,
    multiAZ: Optional[BooleanOptional] = Optional.Absent,
    publiclyAccessible: Optional[BooleanOptional] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    licenseModel: Optional[String] = Optional.Absent,
    dbName: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    optionGroupName: Optional[String] = Optional.Absent,
    copyTagsToSnapshot: Optional[BooleanOptional] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    tdeCredentialArn: Optional[String] = Optional.Absent,
    tdeCredentialPassword: Optional[String] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    domain: Optional[String] = Optional.Absent,
    domainIAMRoleName: Optional[String] = Optional.Absent,
    enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      Optional.Absent,
    enableCloudwatchLogsExports: Optional[Iterable[String]] = Optional.Absent,
    processorFeatures: Optional[Iterable[zio.aws.rds.model.ProcessorFeature]] =
      Optional.Absent,
    useDefaultProcessorFeatures: Optional[BooleanOptional] = Optional.Absent,
    dbParameterGroupName: Optional[String] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    sourceDbiResourceId: Optional[String] = Optional.Absent,
    maxAllocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    sourceDBInstanceAutomatedBackupsArn: Optional[String] = Optional.Absent,
    enableCustomerOwnedIp: Optional[BooleanOptional] = Optional.Absent,
    customIamInstanceProfile: Optional[String] = Optional.Absent,
    backupTarget: Optional[String] = Optional.Absent,
    networkType: Optional[String] = Optional.Absent,
    storageThroughput: Optional[IntegerOptional] = Optional.Absent,
    allocatedStorage: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeRequest = {
    import RestoreDbInstanceToPointInTimeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeRequest
      .builder()
      .optionallyWith(
        sourceDBInstanceIdentifier.map(value => value: java.lang.String)
      )(_.sourceDBInstanceIdentifier)
      .targetDBInstanceIdentifier(targetDBInstanceIdentifier: java.lang.String)
      .optionallyWith(restoreTime.map(value => TStamp.unwrap(value): Instant))(
        _.restoreTime
      )
      .optionallyWith(
        useLatestRestorableTime.map(value => value: java.lang.Boolean)
      )(_.useLatestRestorableTime)
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(
        _.tdeCredentialArn
      )
      .optionallyWith(
        tdeCredentialPassword.map(value => value: java.lang.String)
      )(_.tdeCredentialPassword)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(
        useDefaultProcessorFeatures.map(value => value: java.lang.Boolean)
      )(_.useDefaultProcessorFeatures)
      .optionallyWith(
        dbParameterGroupName.map(value => value: java.lang.String)
      )(_.dbParameterGroupName)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        sourceDbiResourceId.map(value => value: java.lang.String)
      )(_.sourceDbiResourceId)
      .optionallyWith(maxAllocatedStorage.map(value => value: Integer))(
        _.maxAllocatedStorage
      )
      .optionallyWith(
        sourceDBInstanceAutomatedBackupsArn.map(value =>
          value: java.lang.String
        )
      )(_.sourceDBInstanceAutomatedBackupsArn)
      .optionallyWith(
        enableCustomerOwnedIp.map(value => value: java.lang.Boolean)
      )(_.enableCustomerOwnedIp)
      .optionallyWith(
        customIamInstanceProfile.map(value => value: java.lang.String)
      )(_.customIamInstanceProfile)
      .optionallyWith(backupTarget.map(value => value: java.lang.String))(
        _.backupTarget
      )
      .optionallyWith(networkType.map(value => value: java.lang.String))(
        _.networkType
      )
      .optionallyWith(storageThroughput.map(value => value: Integer))(
        _.storageThroughput
      )
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.RestoreDbInstanceToPointInTimeRequest.ReadOnly =
    zio.aws.rds.model.RestoreDbInstanceToPointInTimeRequest
      .wrap(buildAwsValue())
}
object RestoreDbInstanceToPointInTimeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreDbInstanceToPointInTimeRequest =
      zio.aws.rds.model.RestoreDbInstanceToPointInTimeRequest(
        sourceDBInstanceIdentifier.map(value => value),
        targetDBInstanceIdentifier,
        restoreTime.map(value => value),
        useLatestRestorableTime.map(value => value),
        dbInstanceClass.map(value => value),
        port.map(value => value),
        availabilityZone.map(value => value),
        dbSubnetGroupName.map(value => value),
        multiAZ.map(value => value),
        publiclyAccessible.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        licenseModel.map(value => value),
        dbName.map(value => value),
        engine.map(value => value),
        iops.map(value => value),
        optionGroupName.map(value => value),
        copyTagsToSnapshot.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        storageType.map(value => value),
        tdeCredentialArn.map(value => value),
        tdeCredentialPassword.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        domain.map(value => value),
        domainIAMRoleName.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        processorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        useDefaultProcessorFeatures.map(value => value),
        dbParameterGroupName.map(value => value),
        deletionProtection.map(value => value),
        sourceDbiResourceId.map(value => value),
        maxAllocatedStorage.map(value => value),
        sourceDBInstanceAutomatedBackupsArn.map(value => value),
        enableCustomerOwnedIp.map(value => value),
        customIamInstanceProfile.map(value => value),
        backupTarget.map(value => value),
        networkType.map(value => value),
        storageThroughput.map(value => value),
        allocatedStorage.map(value => value)
      )
    def sourceDBInstanceIdentifier: Optional[String]
    def targetDBInstanceIdentifier: String
    def restoreTime: Optional[TStamp]
    def useLatestRestorableTime: Optional[Boolean]
    def dbInstanceClass: Optional[String]
    def port: Optional[IntegerOptional]
    def availabilityZone: Optional[String]
    def dbSubnetGroupName: Optional[String]
    def multiAZ: Optional[BooleanOptional]
    def publiclyAccessible: Optional[BooleanOptional]
    def autoMinorVersionUpgrade: Optional[BooleanOptional]
    def licenseModel: Optional[String]
    def dbName: Optional[String]
    def engine: Optional[String]
    def iops: Optional[IntegerOptional]
    def optionGroupName: Optional[String]
    def copyTagsToSnapshot: Optional[BooleanOptional]
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def storageType: Optional[String]
    def tdeCredentialArn: Optional[String]
    def tdeCredentialPassword: Optional[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def domain: Optional[String]
    def domainIAMRoleName: Optional[String]
    def enableIAMDatabaseAuthentication: Optional[BooleanOptional]
    def enableCloudwatchLogsExports: Optional[List[String]]
    def processorFeatures
        : Optional[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]]
    def useDefaultProcessorFeatures: Optional[BooleanOptional]
    def dbParameterGroupName: Optional[String]
    def deletionProtection: Optional[BooleanOptional]
    def sourceDbiResourceId: Optional[String]
    def maxAllocatedStorage: Optional[IntegerOptional]
    def sourceDBInstanceAutomatedBackupsArn: Optional[String]
    def enableCustomerOwnedIp: Optional[BooleanOptional]
    def customIamInstanceProfile: Optional[String]
    def backupTarget: Optional[String]
    def networkType: Optional[String]
    def storageThroughput: Optional[IntegerOptional]
    def allocatedStorage: Optional[IntegerOptional]
    def getSourceDBInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "sourceDBInstanceIdentifier",
        sourceDBInstanceIdentifier
      )
    def getTargetDBInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetDBInstanceIdentifier)
    def getRestoreTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("restoreTime", restoreTime)
    def getUseLatestRestorableTime: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("useLatestRestorableTime", useLatestRestorableTime)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getTdeCredentialArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArn)
    def getTdeCredentialPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialPassword", tdeCredentialPassword)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getUseDefaultProcessorFeatures: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "useDefaultProcessorFeatures",
        useDefaultProcessorFeatures
      )
    def getDbParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupName)
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getSourceDbiResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceDbiResourceId", sourceDbiResourceId)
    def getMaxAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorage)
    def getSourceDBInstanceAutomatedBackupsArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "sourceDBInstanceAutomatedBackupsArn",
        sourceDBInstanceAutomatedBackupsArn
      )
    def getEnableCustomerOwnedIp: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enableCustomerOwnedIp", enableCustomerOwnedIp)
    def getCustomIamInstanceProfile: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("customIamInstanceProfile", customIamInstanceProfile)
    def getBackupTarget: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupTarget", backupTarget)
    def getNetworkType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkType", networkType)
    def getStorageThroughput: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("storageThroughput", storageThroughput)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeRequest
  ) extends zio.aws.rds.model.RestoreDbInstanceToPointInTimeRequest.ReadOnly {
    override val sourceDBInstanceIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceDBInstanceIdentifier())
        .map(value => value: String)
    override val targetDBInstanceIdentifier: String =
      impl.targetDBInstanceIdentifier(): String
    override val restoreTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.restoreTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val useLatestRestorableTime: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useLatestRestorableTime())
        .map(value => value: Boolean)
    override val dbInstanceClass: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceClass())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val dbSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroupName())
      .map(value => value: String)
    override val multiAZ: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: BooleanOptional)
    override val publiclyAccessible: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publiclyAccessible())
        .map(value => value: BooleanOptional)
    override val autoMinorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val licenseModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => value: String)
    override val dbName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val copyTagsToSnapshot: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyTagsToSnapshot())
        .map(value => value: BooleanOptional)
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val tdeCredentialArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tdeCredentialArn())
      .map(value => value: String)
    override val tdeCredentialPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tdeCredentialPassword())
      .map(value => value: String)
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val domainIAMRoleName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainIAMRoleName())
      .map(value => value: String)
    override val enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableIAMDatabaseAuthentication())
        .map(value => value: BooleanOptional)
    override val enableCloudwatchLogsExports: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCloudwatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val processorFeatures
        : Optional[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processorFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ProcessorFeature.wrap(item)
          }.toList
        )
    override val useDefaultProcessorFeatures: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useDefaultProcessorFeatures())
        .map(value => value: BooleanOptional)
    override val dbParameterGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbParameterGroupName())
      .map(value => value: String)
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val sourceDbiResourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDbiResourceId())
      .map(value => value: String)
    override val maxAllocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxAllocatedStorage())
        .map(value => value: IntegerOptional)
    override val sourceDBInstanceAutomatedBackupsArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceDBInstanceAutomatedBackupsArn())
        .map(value => value: String)
    override val enableCustomerOwnedIp: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCustomerOwnedIp())
        .map(value => value: BooleanOptional)
    override val customIamInstanceProfile: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customIamInstanceProfile())
        .map(value => value: String)
    override val backupTarget: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupTarget())
      .map(value => value: String)
    override val networkType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkType())
      .map(value => value: String)
    override val storageThroughput: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageThroughput())
        .map(value => value: IntegerOptional)
    override val allocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocatedStorage())
        .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeRequest
  ): zio.aws.rds.model.RestoreDbInstanceToPointInTimeRequest.ReadOnly =
    new Wrapper(impl)
}
