package zio.aws.redshift.model
import scala.jdk.CollectionConverters._
sealed trait AquaStatus {
  def unwrap: software.amazon.awssdk.services.redshift.model.AquaStatus
}
object AquaStatus {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.AquaStatus
  ): zio.aws.redshift.model.AquaStatus = value match {
    case software.amazon.awssdk.services.redshift.model.AquaStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.AquaStatus.ENABLED =>
      val r = enabled
      r
    case software.amazon.awssdk.services.redshift.model.AquaStatus.DISABLED =>
      val r = disabled
      r
    case software.amazon.awssdk.services.redshift.model.AquaStatus.APPLYING =>
      val r = applying
      r
  }
  case object unknownToSdkVersion extends zio.aws.redshift.model.AquaStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.AquaStatus =
      software.amazon.awssdk.services.redshift.model.AquaStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object enabled extends zio.aws.redshift.model.AquaStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.AquaStatus =
      software.amazon.awssdk.services.redshift.model.AquaStatus.ENABLED
  }
  case object disabled extends zio.aws.redshift.model.AquaStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.AquaStatus =
      software.amazon.awssdk.services.redshift.model.AquaStatus.DISABLED
  }
  case object applying extends zio.aws.redshift.model.AquaStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.AquaStatus =
      software.amazon.awssdk.services.redshift.model.AquaStatus.APPLYING
  }
}
