package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{LongOptional, Integer, TStamp}
import scala.jdk.CollectionConverters._
final case class Cluster(
    clusterIdentifier: Optional[String] = Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    clusterStatus: Optional[String] = Optional.Absent,
    clusterAvailabilityStatus: Optional[String] = Optional.Absent,
    modifyStatus: Optional[String] = Optional.Absent,
    masterUsername: Optional[String] = Optional.Absent,
    dbName: Optional[String] = Optional.Absent,
    endpoint: Optional[zio.aws.redshift.model.Endpoint] = Optional.Absent,
    clusterCreateTime: Optional[TStamp] = Optional.Absent,
    automatedSnapshotRetentionPeriod: Optional[Integer] = Optional.Absent,
    manualSnapshotRetentionPeriod: Optional[Integer] = Optional.Absent,
    clusterSecurityGroups: Optional[
      Iterable[zio.aws.redshift.model.ClusterSecurityGroupMembership]
    ] = Optional.Absent,
    vpcSecurityGroups: Optional[
      Iterable[zio.aws.redshift.model.VpcSecurityGroupMembership]
    ] = Optional.Absent,
    clusterParameterGroups: Optional[
      Iterable[zio.aws.redshift.model.ClusterParameterGroupStatus]
    ] = Optional.Absent,
    clusterSubnetGroupName: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    pendingModifiedValues: Optional[
      zio.aws.redshift.model.PendingModifiedValues
    ] = Optional.Absent,
    clusterVersion: Optional[String] = Optional.Absent,
    allowVersionUpgrade: Optional[Boolean] = Optional.Absent,
    numberOfNodes: Optional[Integer] = Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent,
    restoreStatus: Optional[zio.aws.redshift.model.RestoreStatus] =
      Optional.Absent,
    dataTransferProgress: Optional[
      zio.aws.redshift.model.DataTransferProgress
    ] = Optional.Absent,
    hsmStatus: Optional[zio.aws.redshift.model.HsmStatus] = Optional.Absent,
    clusterSnapshotCopyStatus: Optional[
      zio.aws.redshift.model.ClusterSnapshotCopyStatus
    ] = Optional.Absent,
    clusterPublicKey: Optional[String] = Optional.Absent,
    clusterNodes: Optional[Iterable[zio.aws.redshift.model.ClusterNode]] =
      Optional.Absent,
    elasticIpStatus: Optional[zio.aws.redshift.model.ElasticIpStatus] =
      Optional.Absent,
    clusterRevisionNumber: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    enhancedVpcRouting: Optional[Boolean] = Optional.Absent,
    iamRoles: Optional[Iterable[zio.aws.redshift.model.ClusterIamRole]] =
      Optional.Absent,
    pendingActions: Optional[Iterable[String]] = Optional.Absent,
    maintenanceTrackName: Optional[String] = Optional.Absent,
    elasticResizeNumberOfNodeOptions: Optional[String] = Optional.Absent,
    deferredMaintenanceWindows: Optional[
      Iterable[zio.aws.redshift.model.DeferredMaintenanceWindow]
    ] = Optional.Absent,
    snapshotScheduleIdentifier: Optional[String] = Optional.Absent,
    snapshotScheduleState: Optional[zio.aws.redshift.model.ScheduleState] =
      Optional.Absent,
    expectedNextSnapshotScheduleTime: Optional[TStamp] = Optional.Absent,
    expectedNextSnapshotScheduleTimeStatus: Optional[String] = Optional.Absent,
    nextMaintenanceWindowStartTime: Optional[TStamp] = Optional.Absent,
    resizeInfo: Optional[zio.aws.redshift.model.ResizeInfo] = Optional.Absent,
    availabilityZoneRelocationStatus: Optional[String] = Optional.Absent,
    clusterNamespaceArn: Optional[String] = Optional.Absent,
    totalStorageCapacityInMegaBytes: Optional[LongOptional] = Optional.Absent,
    aquaConfiguration: Optional[zio.aws.redshift.model.AquaConfiguration] =
      Optional.Absent,
    defaultIamRoleArn: Optional[String] = Optional.Absent,
    reservedNodeExchangeStatus: Optional[
      zio.aws.redshift.model.ReservedNodeExchangeStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.Cluster
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(clusterStatus.map(value => value: java.lang.String))(
        _.clusterStatus
      )
      .optionallyWith(
        clusterAvailabilityStatus.map(value => value: java.lang.String)
      )(_.clusterAvailabilityStatus)
      .optionallyWith(modifyStatus.map(value => value: java.lang.String))(
        _.modifyStatus
      )
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(
        clusterCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.clusterCreateTime)
      .optionallyWith(
        automatedSnapshotRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.automatedSnapshotRetentionPeriod)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterSecurityGroups)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(
        clusterParameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterParameterGroups)
      .optionallyWith(
        clusterSubnetGroupName.map(value => value: java.lang.String)
      )(_.clusterSubnetGroupName)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(
        allowVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowVersionUpgrade)
      .optionallyWith(numberOfNodes.map(value => value: java.lang.Integer))(
        _.numberOfNodes
      )
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(restoreStatus.map(value => value.buildAwsValue()))(
        _.restoreStatus
      )
      .optionallyWith(dataTransferProgress.map(value => value.buildAwsValue()))(
        _.dataTransferProgress
      )
      .optionallyWith(hsmStatus.map(value => value.buildAwsValue()))(
        _.hsmStatus
      )
      .optionallyWith(
        clusterSnapshotCopyStatus.map(value => value.buildAwsValue())
      )(_.clusterSnapshotCopyStatus)
      .optionallyWith(clusterPublicKey.map(value => value: java.lang.String))(
        _.clusterPublicKey
      )
      .optionallyWith(
        clusterNodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterNodes)
      .optionallyWith(elasticIpStatus.map(value => value.buildAwsValue()))(
        _.elasticIpStatus
      )
      .optionallyWith(
        clusterRevisionNumber.map(value => value: java.lang.String)
      )(_.clusterRevisionNumber)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .optionallyWith(
        iamRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.iamRoles)
      .optionallyWith(
        pendingActions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.pendingActions)
      .optionallyWith(
        maintenanceTrackName.map(value => value: java.lang.String)
      )(_.maintenanceTrackName)
      .optionallyWith(
        elasticResizeNumberOfNodeOptions.map(value => value: java.lang.String)
      )(_.elasticResizeNumberOfNodeOptions)
      .optionallyWith(
        deferredMaintenanceWindows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deferredMaintenanceWindows)
      .optionallyWith(
        snapshotScheduleIdentifier.map(value => value: java.lang.String)
      )(_.snapshotScheduleIdentifier)
      .optionallyWith(snapshotScheduleState.map(value => value.unwrap))(
        _.snapshotScheduleState
      )
      .optionallyWith(
        expectedNextSnapshotScheduleTime.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.expectedNextSnapshotScheduleTime)
      .optionallyWith(
        expectedNextSnapshotScheduleTimeStatus.map(value =>
          value: java.lang.String
        )
      )(_.expectedNextSnapshotScheduleTimeStatus)
      .optionallyWith(
        nextMaintenanceWindowStartTime.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.nextMaintenanceWindowStartTime)
      .optionallyWith(resizeInfo.map(value => value.buildAwsValue()))(
        _.resizeInfo
      )
      .optionallyWith(
        availabilityZoneRelocationStatus.map(value => value: java.lang.String)
      )(_.availabilityZoneRelocationStatus)
      .optionallyWith(
        clusterNamespaceArn.map(value => value: java.lang.String)
      )(_.clusterNamespaceArn)
      .optionallyWith(
        totalStorageCapacityInMegaBytes.map(value => value: java.lang.Long)
      )(_.totalStorageCapacityInMegaBytes)
      .optionallyWith(aquaConfiguration.map(value => value.buildAwsValue()))(
        _.aquaConfiguration
      )
      .optionallyWith(defaultIamRoleArn.map(value => value: java.lang.String))(
        _.defaultIamRoleArn
      )
      .optionallyWith(
        reservedNodeExchangeStatus.map(value => value.buildAwsValue())
      )(_.reservedNodeExchangeStatus)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.Cluster.ReadOnly =
    zio.aws.redshift.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.redshift.model.Cluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.Cluster =
      zio.aws.redshift.model.Cluster(
        clusterIdentifier.map(value => value),
        nodeType.map(value => value),
        clusterStatus.map(value => value),
        clusterAvailabilityStatus.map(value => value),
        modifyStatus.map(value => value),
        masterUsername.map(value => value),
        dbName.map(value => value),
        endpoint.map(value => value.asEditable),
        clusterCreateTime.map(value => value),
        automatedSnapshotRetentionPeriod.map(value => value),
        manualSnapshotRetentionPeriod.map(value => value),
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clusterParameterGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clusterSubnetGroupName.map(value => value),
        vpcId.map(value => value),
        availabilityZone.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        clusterVersion.map(value => value),
        allowVersionUpgrade.map(value => value),
        numberOfNodes.map(value => value),
        publiclyAccessible.map(value => value),
        encrypted.map(value => value),
        restoreStatus.map(value => value.asEditable),
        dataTransferProgress.map(value => value.asEditable),
        hsmStatus.map(value => value.asEditable),
        clusterSnapshotCopyStatus.map(value => value.asEditable),
        clusterPublicKey.map(value => value),
        clusterNodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        elasticIpStatus.map(value => value.asEditable),
        clusterRevisionNumber.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        enhancedVpcRouting.map(value => value),
        iamRoles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pendingActions.map(value => value),
        maintenanceTrackName.map(value => value),
        elasticResizeNumberOfNodeOptions.map(value => value),
        deferredMaintenanceWindows.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        snapshotScheduleIdentifier.map(value => value),
        snapshotScheduleState.map(value => value),
        expectedNextSnapshotScheduleTime.map(value => value),
        expectedNextSnapshotScheduleTimeStatus.map(value => value),
        nextMaintenanceWindowStartTime.map(value => value),
        resizeInfo.map(value => value.asEditable),
        availabilityZoneRelocationStatus.map(value => value),
        clusterNamespaceArn.map(value => value),
        totalStorageCapacityInMegaBytes.map(value => value),
        aquaConfiguration.map(value => value.asEditable),
        defaultIamRoleArn.map(value => value),
        reservedNodeExchangeStatus.map(value => value.asEditable)
      )
    def clusterIdentifier: Optional[String]
    def nodeType: Optional[String]
    def clusterStatus: Optional[String]
    def clusterAvailabilityStatus: Optional[String]
    def modifyStatus: Optional[String]
    def masterUsername: Optional[String]
    def dbName: Optional[String]
    def endpoint: Optional[zio.aws.redshift.model.Endpoint.ReadOnly]
    def clusterCreateTime: Optional[TStamp]
    def automatedSnapshotRetentionPeriod: Optional[Integer]
    def manualSnapshotRetentionPeriod: Optional[Integer]
    def clusterSecurityGroups: Optional[
      List[zio.aws.redshift.model.ClusterSecurityGroupMembership.ReadOnly]
    ]
    def vpcSecurityGroups: Optional[
      List[zio.aws.redshift.model.VpcSecurityGroupMembership.ReadOnly]
    ]
    def clusterParameterGroups: Optional[
      List[zio.aws.redshift.model.ClusterParameterGroupStatus.ReadOnly]
    ]
    def clusterSubnetGroupName: Optional[String]
    def vpcId: Optional[String]
    def availabilityZone: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def pendingModifiedValues
        : Optional[zio.aws.redshift.model.PendingModifiedValues.ReadOnly]
    def clusterVersion: Optional[String]
    def allowVersionUpgrade: Optional[Boolean]
    def numberOfNodes: Optional[Integer]
    def publiclyAccessible: Optional[Boolean]
    def encrypted: Optional[Boolean]
    def restoreStatus: Optional[zio.aws.redshift.model.RestoreStatus.ReadOnly]
    def dataTransferProgress
        : Optional[zio.aws.redshift.model.DataTransferProgress.ReadOnly]
    def hsmStatus: Optional[zio.aws.redshift.model.HsmStatus.ReadOnly]
    def clusterSnapshotCopyStatus
        : Optional[zio.aws.redshift.model.ClusterSnapshotCopyStatus.ReadOnly]
    def clusterPublicKey: Optional[String]
    def clusterNodes
        : Optional[List[zio.aws.redshift.model.ClusterNode.ReadOnly]]
    def elasticIpStatus
        : Optional[zio.aws.redshift.model.ElasticIpStatus.ReadOnly]
    def clusterRevisionNumber: Optional[String]
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def kmsKeyId: Optional[String]
    def enhancedVpcRouting: Optional[Boolean]
    def iamRoles: Optional[List[zio.aws.redshift.model.ClusterIamRole.ReadOnly]]
    def pendingActions: Optional[List[String]]
    def maintenanceTrackName: Optional[String]
    def elasticResizeNumberOfNodeOptions: Optional[String]
    def deferredMaintenanceWindows: Optional[
      List[zio.aws.redshift.model.DeferredMaintenanceWindow.ReadOnly]
    ]
    def snapshotScheduleIdentifier: Optional[String]
    def snapshotScheduleState: Optional[zio.aws.redshift.model.ScheduleState]
    def expectedNextSnapshotScheduleTime: Optional[TStamp]
    def expectedNextSnapshotScheduleTimeStatus: Optional[String]
    def nextMaintenanceWindowStartTime: Optional[TStamp]
    def resizeInfo: Optional[zio.aws.redshift.model.ResizeInfo.ReadOnly]
    def availabilityZoneRelocationStatus: Optional[String]
    def clusterNamespaceArn: Optional[String]
    def totalStorageCapacityInMegaBytes: Optional[LongOptional]
    def aquaConfiguration
        : Optional[zio.aws.redshift.model.AquaConfiguration.ReadOnly]
    def defaultIamRoleArn: Optional[String]
    def reservedNodeExchangeStatus
        : Optional[zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getClusterStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterStatus", clusterStatus)
    def getClusterAvailabilityStatus: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterAvailabilityStatus", clusterAvailabilityStatus)
    def getModifyStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("modifyStatus", modifyStatus)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getEndpoint
        : ZIO[Any, AwsError, zio.aws.redshift.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getClusterCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getAutomatedSnapshotRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "automatedSnapshotRetentionPeriod",
        automatedSnapshotRetentionPeriod
      )
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getClusterSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterSecurityGroupMembership.ReadOnly
    ]] =
      AwsError.unwrapOptionField("clusterSecurityGroups", clusterSecurityGroups)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getClusterParameterGroups: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterParameterGroupStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "clusterParameterGroups",
      clusterParameterGroups
    )
    def getClusterSubnetGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterSubnetGroupName", clusterSubnetGroupName)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.PendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getAllowVersionUpgrade: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowVersionUpgrade", allowVersionUpgrade)
    def getNumberOfNodes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getRestoreStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.RestoreStatus.ReadOnly] =
      AwsError.unwrapOptionField("restoreStatus", restoreStatus)
    def getDataTransferProgress: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.DataTransferProgress.ReadOnly
    ] = AwsError.unwrapOptionField("dataTransferProgress", dataTransferProgress)
    def getHsmStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.HsmStatus.ReadOnly] =
      AwsError.unwrapOptionField("hsmStatus", hsmStatus)
    def getClusterSnapshotCopyStatus: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ClusterSnapshotCopyStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "clusterSnapshotCopyStatus",
      clusterSnapshotCopyStatus
    )
    def getClusterPublicKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterPublicKey", clusterPublicKey)
    def getClusterNodes: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterNode.ReadOnly
    ]] = AwsError.unwrapOptionField("clusterNodes", clusterNodes)
    def getElasticIpStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.ElasticIpStatus.ReadOnly] =
      AwsError.unwrapOptionField("elasticIpStatus", elasticIpStatus)
    def getClusterRevisionNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterRevisionNumber", clusterRevisionNumber)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getIamRoles: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterIamRole.ReadOnly
    ]] = AwsError.unwrapOptionField("iamRoles", iamRoles)
    def getPendingActions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("pendingActions", pendingActions)
    def getMaintenanceTrackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getElasticResizeNumberOfNodeOptions: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "elasticResizeNumberOfNodeOptions",
        elasticResizeNumberOfNodeOptions
      )
    def getDeferredMaintenanceWindows: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.DeferredMaintenanceWindow.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "deferredMaintenanceWindows",
      deferredMaintenanceWindows
    )
    def getSnapshotScheduleIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "snapshotScheduleIdentifier",
        snapshotScheduleIdentifier
      )
    def getSnapshotScheduleState
        : ZIO[Any, AwsError, zio.aws.redshift.model.ScheduleState] =
      AwsError.unwrapOptionField("snapshotScheduleState", snapshotScheduleState)
    def getExpectedNextSnapshotScheduleTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "expectedNextSnapshotScheduleTime",
        expectedNextSnapshotScheduleTime
      )
    def getExpectedNextSnapshotScheduleTimeStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "expectedNextSnapshotScheduleTimeStatus",
        expectedNextSnapshotScheduleTimeStatus
      )
    def getNextMaintenanceWindowStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "nextMaintenanceWindowStartTime",
        nextMaintenanceWindowStartTime
      )
    def getResizeInfo
        : ZIO[Any, AwsError, zio.aws.redshift.model.ResizeInfo.ReadOnly] =
      AwsError.unwrapOptionField("resizeInfo", resizeInfo)
    def getAvailabilityZoneRelocationStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "availabilityZoneRelocationStatus",
        availabilityZoneRelocationStatus
      )
    def getClusterNamespaceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterNamespaceArn", clusterNamespaceArn)
    def getTotalStorageCapacityInMegaBytes: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField(
        "totalStorageCapacityInMegaBytes",
        totalStorageCapacityInMegaBytes
      )
    def getAquaConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.AquaConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("aquaConfiguration", aquaConfiguration)
    def getDefaultIamRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultIamRoleArn", defaultIamRoleArn)
    def getReservedNodeExchangeStatus: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "reservedNodeExchangeStatus",
      reservedNodeExchangeStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.Cluster
  ) extends zio.aws.redshift.model.Cluster.ReadOnly {
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val clusterStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterStatus())
      .map(value => value: String)
    override val clusterAvailabilityStatus: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterAvailabilityStatus())
        .map(value => value: String)
    override val modifyStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.modifyStatus())
      .map(value => value: String)
    override val masterUsername: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUsername())
      .map(value => value: String)
    override val dbName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => value: String)
    override val endpoint: Optional[zio.aws.redshift.model.Endpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value => zio.aws.redshift.model.Endpoint.wrap(value))
    override val clusterCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterCreateTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val automatedSnapshotRetentionPeriod: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automatedSnapshotRetentionPeriod())
        .map(value => value: Integer)
    override val manualSnapshotRetentionPeriod: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manualSnapshotRetentionPeriod())
        .map(value => value: Integer)
    override val clusterSecurityGroups: Optional[
      List[zio.aws.redshift.model.ClusterSecurityGroupMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.ClusterSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val vpcSecurityGroups: Optional[
      List[zio.aws.redshift.model.VpcSecurityGroupMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val clusterParameterGroups: Optional[
      List[zio.aws.redshift.model.ClusterParameterGroupStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterParameterGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.ClusterParameterGroupStatus.wrap(item)
        }.toList
      )
    override val clusterSubnetGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterSubnetGroupName())
        .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val pendingModifiedValues
        : Optional[zio.aws.redshift.model.PendingModifiedValues.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingModifiedValues())
        .map(value => zio.aws.redshift.model.PendingModifiedValues.wrap(value))
    override val clusterVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterVersion())
      .map(value => value: String)
    override val allowVersionUpgrade: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allowVersionUpgrade())
      .map(value => value: Boolean)
    override val numberOfNodes: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfNodes())
      .map(value => value: Integer)
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val restoreStatus
        : Optional[zio.aws.redshift.model.RestoreStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restoreStatus())
        .map(value => zio.aws.redshift.model.RestoreStatus.wrap(value))
    override val dataTransferProgress
        : Optional[zio.aws.redshift.model.DataTransferProgress.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataTransferProgress())
        .map(value => zio.aws.redshift.model.DataTransferProgress.wrap(value))
    override val hsmStatus
        : Optional[zio.aws.redshift.model.HsmStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmStatus())
        .map(value => zio.aws.redshift.model.HsmStatus.wrap(value))
    override val clusterSnapshotCopyStatus
        : Optional[zio.aws.redshift.model.ClusterSnapshotCopyStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterSnapshotCopyStatus())
        .map(value =>
          zio.aws.redshift.model.ClusterSnapshotCopyStatus.wrap(value)
        )
    override val clusterPublicKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterPublicKey())
      .map(value => value: String)
    override val clusterNodes
        : Optional[List[zio.aws.redshift.model.ClusterNode.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterNodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.ClusterNode.wrap(item)
          }.toList
        )
    override val elasticIpStatus
        : Optional[zio.aws.redshift.model.ElasticIpStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticIpStatus())
        .map(value => zio.aws.redshift.model.ElasticIpStatus.wrap(value))
    override val clusterRevisionNumber: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterRevisionNumber())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val enhancedVpcRouting: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enhancedVpcRouting())
      .map(value => value: Boolean)
    override val iamRoles
        : Optional[List[zio.aws.redshift.model.ClusterIamRole.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamRoles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.ClusterIamRole.wrap(item)
          }.toList
        )
    override val pendingActions: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingActions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maintenanceTrackName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceTrackName())
      .map(value => value: String)
    override val elasticResizeNumberOfNodeOptions: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticResizeNumberOfNodeOptions())
        .map(value => value: String)
    override val deferredMaintenanceWindows: Optional[
      List[zio.aws.redshift.model.DeferredMaintenanceWindow.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deferredMaintenanceWindows())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.DeferredMaintenanceWindow.wrap(item)
        }.toList
      )
    override val snapshotScheduleIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotScheduleIdentifier())
        .map(value => value: String)
    override val snapshotScheduleState
        : Optional[zio.aws.redshift.model.ScheduleState] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotScheduleState())
      .map(value => zio.aws.redshift.model.ScheduleState.wrap(value))
    override val expectedNextSnapshotScheduleTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedNextSnapshotScheduleTime())
        .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val expectedNextSnapshotScheduleTimeStatus: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedNextSnapshotScheduleTimeStatus())
        .map(value => value: String)
    override val nextMaintenanceWindowStartTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextMaintenanceWindowStartTime())
        .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val resizeInfo
        : Optional[zio.aws.redshift.model.ResizeInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resizeInfo())
        .map(value => zio.aws.redshift.model.ResizeInfo.wrap(value))
    override val availabilityZoneRelocationStatus: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZoneRelocationStatus())
        .map(value => value: String)
    override val clusterNamespaceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterNamespaceArn())
      .map(value => value: String)
    override val totalStorageCapacityInMegaBytes: Optional[LongOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalStorageCapacityInMegaBytes())
        .map(value => value: LongOptional)
    override val aquaConfiguration
        : Optional[zio.aws.redshift.model.AquaConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aquaConfiguration())
        .map(value => zio.aws.redshift.model.AquaConfiguration.wrap(value))
    override val defaultIamRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultIamRoleArn())
      .map(value => value: String)
    override val reservedNodeExchangeStatus
        : Optional[zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedNodeExchangeStatus())
        .map(value =>
          zio.aws.redshift.model.ReservedNodeExchangeStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.Cluster
  ): zio.aws.redshift.model.Cluster.ReadOnly = new Wrapper(impl)
}
