package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClusterParameterGroup(
    parameterGroupName: Optional[String] = Optional.Absent,
    parameterGroupFamily: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ClusterParameterGroup = {
    import ClusterParameterGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ClusterParameterGroup
      .builder()
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(
        parameterGroupFamily.map(value => value: java.lang.String)
      )(_.parameterGroupFamily)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ClusterParameterGroup.ReadOnly =
    zio.aws.redshift.model.ClusterParameterGroup.wrap(buildAwsValue())
}
object ClusterParameterGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ClusterParameterGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ClusterParameterGroup =
      zio.aws.redshift.model.ClusterParameterGroup(
        parameterGroupName.map(value => value),
        parameterGroupFamily.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def parameterGroupName: Optional[String]
    def parameterGroupFamily: Optional[String]
    def description: Optional[String]
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getParameterGroupFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupFamily", parameterGroupFamily)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ClusterParameterGroup
  ) extends zio.aws.redshift.model.ClusterParameterGroup.ReadOnly {
    override val parameterGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterGroupName())
      .map(value => value: String)
    override val parameterGroupFamily: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterGroupFamily())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ClusterParameterGroup
  ): zio.aws.redshift.model.ClusterParameterGroup.ReadOnly = new Wrapper(impl)
}
