package zio.aws.redshift.model
import scala.jdk.CollectionConverters._
sealed trait DataShareStatus {
  def unwrap: software.amazon.awssdk.services.redshift.model.DataShareStatus
}
object DataShareStatus {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.DataShareStatus
  ): zio.aws.redshift.model.DataShareStatus = value match {
    case software.amazon.awssdk.services.redshift.model.DataShareStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.DataShareStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.redshift.model.DataShareStatus.PENDING_AUTHORIZATION =>
      val r = PENDING_AUTHORIZATION
      r
    case software.amazon.awssdk.services.redshift.model.DataShareStatus.AUTHORIZED =>
      val r = AUTHORIZED
      r
    case software.amazon.awssdk.services.redshift.model.DataShareStatus.DEAUTHORIZED =>
      val r = DEAUTHORIZED
      r
    case software.amazon.awssdk.services.redshift.model.DataShareStatus.REJECTED =>
      val r = REJECTED
      r
    case software.amazon.awssdk.services.redshift.model.DataShareStatus.AVAILABLE =>
      val r = AVAILABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.DataShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.DataShareStatus =
      software.amazon.awssdk.services.redshift.model.DataShareStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.redshift.model.DataShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.DataShareStatus =
      software.amazon.awssdk.services.redshift.model.DataShareStatus.ACTIVE
  }
  case object PENDING_AUTHORIZATION
      extends zio.aws.redshift.model.DataShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.DataShareStatus =
      software.amazon.awssdk.services.redshift.model.DataShareStatus.PENDING_AUTHORIZATION
  }
  case object AUTHORIZED extends zio.aws.redshift.model.DataShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.DataShareStatus =
      software.amazon.awssdk.services.redshift.model.DataShareStatus.AUTHORIZED
  }
  case object DEAUTHORIZED extends zio.aws.redshift.model.DataShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.DataShareStatus =
      software.amazon.awssdk.services.redshift.model.DataShareStatus.DEAUTHORIZED
  }
  case object REJECTED extends zio.aws.redshift.model.DataShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.DataShareStatus =
      software.amazon.awssdk.services.redshift.model.DataShareStatus.REJECTED
  }
  case object AVAILABLE extends zio.aws.redshift.model.DataShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.DataShareStatus =
      software.amazon.awssdk.services.redshift.model.DataShareStatus.AVAILABLE
  }
}
