package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DeleteClusterRequest(
    clusterIdentifier: String,
    skipFinalClusterSnapshot: Optional[Boolean] = Optional.Absent,
    finalClusterSnapshotIdentifier: Optional[String] = Optional.Absent,
    finalClusterSnapshotRetentionPeriod: Optional[IntegerOptional] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeleteClusterRequest = {
    import DeleteClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeleteClusterRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(
        skipFinalClusterSnapshot.map(value => value: java.lang.Boolean)
      )(_.skipFinalClusterSnapshot)
      .optionallyWith(
        finalClusterSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.finalClusterSnapshotIdentifier)
      .optionallyWith(
        finalClusterSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.finalClusterSnapshotRetentionPeriod)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DeleteClusterRequest.ReadOnly =
    zio.aws.redshift.model.DeleteClusterRequest.wrap(buildAwsValue())
}
object DeleteClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeleteClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeleteClusterRequest =
      zio.aws.redshift.model.DeleteClusterRequest(
        clusterIdentifier,
        skipFinalClusterSnapshot.map(value => value),
        finalClusterSnapshotIdentifier.map(value => value),
        finalClusterSnapshotRetentionPeriod.map(value => value)
      )
    def clusterIdentifier: String
    def skipFinalClusterSnapshot: Optional[Boolean]
    def finalClusterSnapshotIdentifier: Optional[String]
    def finalClusterSnapshotRetentionPeriod: Optional[IntegerOptional]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getSkipFinalClusterSnapshot: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("skipFinalClusterSnapshot", skipFinalClusterSnapshot)
    def getFinalClusterSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "finalClusterSnapshotIdentifier",
        finalClusterSnapshotIdentifier
      )
    def getFinalClusterSnapshotRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "finalClusterSnapshotRetentionPeriod",
      finalClusterSnapshotRetentionPeriod
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeleteClusterRequest
  ) extends zio.aws.redshift.model.DeleteClusterRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val skipFinalClusterSnapshot: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skipFinalClusterSnapshot())
        .map(value => value: Boolean)
    override val finalClusterSnapshotIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finalClusterSnapshotIdentifier())
        .map(value => value: String)
    override val finalClusterSnapshotRetentionPeriod
        : Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.finalClusterSnapshotRetentionPeriod())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeleteClusterRequest
  ): zio.aws.redshift.model.DeleteClusterRequest.ReadOnly = new Wrapper(impl)
}
