package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteClusterSubnetGroupRequest(
    clusterSubnetGroupName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupRequest = {
    import DeleteClusterSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupRequest
      .builder()
      .clusterSubnetGroupName(clusterSubnetGroupName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DeleteClusterSubnetGroupRequest.ReadOnly =
    zio.aws.redshift.model.DeleteClusterSubnetGroupRequest.wrap(buildAwsValue())
}
object DeleteClusterSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeleteClusterSubnetGroupRequest =
      zio.aws.redshift.model
        .DeleteClusterSubnetGroupRequest(clusterSubnetGroupName)
    def clusterSubnetGroupName: String
    def getClusterSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterSubnetGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupRequest
  ) extends zio.aws.redshift.model.DeleteClusterSubnetGroupRequest.ReadOnly {
    override val clusterSubnetGroupName: String =
      impl.clusterSubnetGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupRequest
  ): zio.aws.redshift.model.DeleteClusterSubnetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
