package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeClusterVersionsRequest(
    clusterVersion: Optional[String] = Optional.Absent,
    clusterParameterGroupFamily: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest = {
    import DescribeClusterVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest
      .builder()
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(
        clusterParameterGroupFamily.map(value => value: java.lang.String)
      )(_.clusterParameterGroupFamily)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterVersionsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeClusterVersionsRequest.wrap(buildAwsValue())
}
object DescribeClusterVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeClusterVersionsRequest =
      zio.aws.redshift.model.DescribeClusterVersionsRequest(
        clusterVersion.map(value => value),
        clusterParameterGroupFamily.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def clusterVersion: Optional[String]
    def clusterParameterGroupFamily: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getClusterParameterGroupFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "clusterParameterGroupFamily",
        clusterParameterGroupFamily
      )
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest
  ) extends zio.aws.redshift.model.DescribeClusterVersionsRequest.ReadOnly {
    override val clusterVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterVersion())
      .map(value => value: String)
    override val clusterParameterGroupFamily: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterParameterGroupFamily())
        .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest
  ): zio.aws.redshift.model.DescribeClusterVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
