package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeDataSharesForConsumerRequest(
    consumerArn: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.redshift.model.DataShareStatusForConsumer] =
      Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest = {
    import DescribeDataSharesForConsumerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest
      .builder()
      .optionallyWith(consumerArn.map(value => value: java.lang.String))(
        _.consumerArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeDataSharesForConsumerRequest.ReadOnly =
    zio.aws.redshift.model.DescribeDataSharesForConsumerRequest
      .wrap(buildAwsValue())
}
object DescribeDataSharesForConsumerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeDataSharesForConsumerRequest =
      zio.aws.redshift.model.DescribeDataSharesForConsumerRequest(
        consumerArn.map(value => value),
        status.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def consumerArn: Optional[String]
    def status: Optional[zio.aws.redshift.model.DataShareStatusForConsumer]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getConsumerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("consumerArn", consumerArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.DataShareStatusForConsumer
    ] = AwsError.unwrapOptionField("status", status)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest
  ) extends zio.aws.redshift.model.DescribeDataSharesForConsumerRequest.ReadOnly {
    override val consumerArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.consumerArn())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.redshift.model.DataShareStatusForConsumer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.redshift.model.DataShareStatusForConsumer.wrap(value)
        )
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest
  ): zio.aws.redshift.model.DescribeDataSharesForConsumerRequest.ReadOnly =
    new Wrapper(impl)
}
