package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeNodeConfigurationOptionsResponse(
    nodeConfigurationOptionList: Optional[
      Iterable[zio.aws.redshift.model.NodeConfigurationOption]
    ] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse = {
    import DescribeNodeConfigurationOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse
      .builder()
      .optionallyWith(
        nodeConfigurationOptionList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodeConfigurationOptionList)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse
      .wrap(buildAwsValue())
}
object DescribeNodeConfigurationOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse =
      zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse(
        nodeConfigurationOptionList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def nodeConfigurationOptionList: Optional[
      List[zio.aws.redshift.model.NodeConfigurationOption.ReadOnly]
    ]
    def marker: Optional[String]
    def getNodeConfigurationOptionList: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.NodeConfigurationOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "nodeConfigurationOptionList",
      nodeConfigurationOptionList
    )
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse
  ) extends zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse.ReadOnly {
    override val nodeConfigurationOptionList: Optional[
      List[zio.aws.redshift.model.NodeConfigurationOption.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeConfigurationOptionList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.NodeConfigurationOption.wrap(item)
        }.toList
      )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse
  ): zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
