package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeReservedNodeOfferingsRequest(
    reservedNodeOfferingId: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest = {
    import DescribeReservedNodeOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest
      .builder()
      .optionallyWith(
        reservedNodeOfferingId.map(value => value: java.lang.String)
      )(_.reservedNodeOfferingId)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeReservedNodeOfferingsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeReservedNodeOfferingsRequest
      .wrap(buildAwsValue())
}
object DescribeReservedNodeOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeReservedNodeOfferingsRequest =
      zio.aws.redshift.model.DescribeReservedNodeOfferingsRequest(
        reservedNodeOfferingId.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def reservedNodeOfferingId: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getReservedNodeOfferingId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("reservedNodeOfferingId", reservedNodeOfferingId)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest
  ) extends zio.aws.redshift.model.DescribeReservedNodeOfferingsRequest.ReadOnly {
    override val reservedNodeOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedNodeOfferingId())
        .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest
  ): zio.aws.redshift.model.DescribeReservedNodeOfferingsRequest.ReadOnly =
    new Wrapper(impl)
}
