package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetClusterCredentialsRequest(
    dbUser: String,
    dbName: Optional[String] = Optional.Absent,
    clusterIdentifier: String,
    durationSeconds: Optional[IntegerOptional] = Optional.Absent,
    autoCreate: Optional[BooleanOptional] = Optional.Absent,
    dbGroups: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest = {
    import GetClusterCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest
      .builder()
      .dbUser(dbUser: java.lang.String)
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(durationSeconds.map(value => value: Integer))(
        _.durationSeconds
      )
      .optionallyWith(autoCreate.map(value => value: java.lang.Boolean))(
        _.autoCreate
      )
      .optionallyWith(
        dbGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dbGroups)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.GetClusterCredentialsRequest.ReadOnly =
    zio.aws.redshift.model.GetClusterCredentialsRequest.wrap(buildAwsValue())
}
object GetClusterCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.GetClusterCredentialsRequest =
      zio.aws.redshift.model.GetClusterCredentialsRequest(
        dbUser,
        dbName.map(value => value),
        clusterIdentifier,
        durationSeconds.map(value => value),
        autoCreate.map(value => value),
        dbGroups.map(value => value)
      )
    def dbUser: String
    def dbName: Optional[String]
    def clusterIdentifier: String
    def durationSeconds: Optional[IntegerOptional]
    def autoCreate: Optional[BooleanOptional]
    def dbGroups: Optional[List[String]]
    def getDbUser: ZIO[Any, Nothing, String] = ZIO.succeed(dbUser)
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getDurationSeconds: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
    def getAutoCreate: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("autoCreate", autoCreate)
    def getDbGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dbGroups", dbGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest
  ) extends zio.aws.redshift.model.GetClusterCredentialsRequest.ReadOnly {
    override val dbUser: String = impl.dbUser(): String
    override val dbName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => value: String)
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val durationSeconds: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationSeconds())
        .map(value => value: IntegerOptional)
    override val autoCreate: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.autoCreate())
      .map(value => value: BooleanOptional)
    override val dbGroups: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.dbGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest
  ): zio.aws.redshift.model.GetClusterCredentialsRequest.ReadOnly = new Wrapper(
    impl
  )
}
