package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{TStamp, SensitiveString}
import scala.jdk.CollectionConverters._
final case class GetClusterCredentialsResponse(
    dbUser: Optional[String] = Optional.Absent,
    dbPassword: Optional[SensitiveString] = Optional.Absent,
    expiration: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse = {
    import GetClusterCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse
      .builder()
      .optionallyWith(dbUser.map(value => value: java.lang.String))(_.dbUser)
      .optionallyWith(
        dbPassword.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.dbPassword)
      .optionallyWith(expiration.map(value => TStamp.unwrap(value): Instant))(
        _.expiration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.GetClusterCredentialsResponse.ReadOnly =
    zio.aws.redshift.model.GetClusterCredentialsResponse.wrap(buildAwsValue())
}
object GetClusterCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.GetClusterCredentialsResponse =
      zio.aws.redshift.model.GetClusterCredentialsResponse(
        dbUser.map(value => value),
        dbPassword.map(value => value),
        expiration.map(value => value)
      )
    def dbUser: Optional[String]
    def dbPassword: Optional[SensitiveString]
    def expiration: Optional[TStamp]
    def getDbUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getDbPassword: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("dbPassword", dbPassword)
    def getExpiration: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("expiration", expiration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse
  ) extends zio.aws.redshift.model.GetClusterCredentialsResponse.ReadOnly {
    override val dbUser: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbUser())
      .map(value => value: String)
    override val dbPassword: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.dbPassword())
      .map(value => zio.aws.redshift.model.primitives.SensitiveString(value))
    override val expiration: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expiration())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse
  ): zio.aws.redshift.model.GetClusterCredentialsResponse.ReadOnly =
    new Wrapper(impl)
}
