package zio.aws.redshift.model
import scala.jdk.CollectionConverters._
sealed trait Mode {
  def unwrap: software.amazon.awssdk.services.redshift.model.Mode
}
object Mode {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.Mode
  ): zio.aws.redshift.model.Mode = value match {
    case software.amazon.awssdk.services.redshift.model.Mode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.Mode.STANDARD =>
      val r = standard
      r
    case software.amazon.awssdk.services.redshift.model.Mode.HIGH_PERFORMANCE =>
      val r = `high-performance`
      r
  }
  case object unknownToSdkVersion extends zio.aws.redshift.model.Mode {
    override def unwrap: software.amazon.awssdk.services.redshift.model.Mode =
      software.amazon.awssdk.services.redshift.model.Mode.UNKNOWN_TO_SDK_VERSION
  }
  case object standard extends zio.aws.redshift.model.Mode {
    override def unwrap: software.amazon.awssdk.services.redshift.model.Mode =
      software.amazon.awssdk.services.redshift.model.Mode.STANDARD
  }
  case object `high-performance` extends zio.aws.redshift.model.Mode {
    override def unwrap: software.amazon.awssdk.services.redshift.model.Mode =
      software.amazon.awssdk.services.redshift.model.Mode.HIGH_PERFORMANCE
  }
}
