package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OrderableClusterOption(
    clusterVersion: Optional[String] = Optional.Absent,
    clusterType: Optional[String] = Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    availabilityZones: Optional[
      Iterable[zio.aws.redshift.model.AvailabilityZone]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.OrderableClusterOption = {
    import OrderableClusterOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.OrderableClusterOption
      .builder()
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(clusterType.map(value => value: java.lang.String))(
        _.clusterType
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.OrderableClusterOption.ReadOnly =
    zio.aws.redshift.model.OrderableClusterOption.wrap(buildAwsValue())
}
object OrderableClusterOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.OrderableClusterOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.OrderableClusterOption =
      zio.aws.redshift.model.OrderableClusterOption(
        clusterVersion.map(value => value),
        clusterType.map(value => value),
        nodeType.map(value => value),
        availabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterVersion: Optional[String]
    def clusterType: Optional[String]
    def nodeType: Optional[String]
    def availabilityZones
        : Optional[List[zio.aws.redshift.model.AvailabilityZone.ReadOnly]]
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getClusterType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.AvailabilityZone.ReadOnly
    ]] = AwsError.unwrapOptionField("availabilityZones", availabilityZones)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.OrderableClusterOption
  ) extends zio.aws.redshift.model.OrderableClusterOption.ReadOnly {
    override val clusterVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterVersion())
      .map(value => value: String)
    override val clusterType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterType())
      .map(value => value: String)
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val availabilityZones
        : Optional[List[zio.aws.redshift.model.AvailabilityZone.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.AvailabilityZone.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.OrderableClusterOption
  ): zio.aws.redshift.model.OrderableClusterOption.ReadOnly = new Wrapper(impl)
}
