package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{
  TStamp,
  PartnerIntegrationStatusMessage,
  PartnerIntegrationPartnerName,
  PartnerIntegrationDatabaseName
}
import scala.jdk.CollectionConverters._
final case class PartnerIntegrationInfo(
    databaseName: Optional[PartnerIntegrationDatabaseName] = Optional.Absent,
    partnerName: Optional[PartnerIntegrationPartnerName] = Optional.Absent,
    status: Optional[zio.aws.redshift.model.PartnerIntegrationStatus] =
      Optional.Absent,
    statusMessage: Optional[PartnerIntegrationStatusMessage] = Optional.Absent,
    createdAt: Optional[TStamp] = Optional.Absent,
    updatedAt: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.PartnerIntegrationInfo = {
    import PartnerIntegrationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.PartnerIntegrationInfo
      .builder()
      .optionallyWith(
        databaseName.map(value =>
          PartnerIntegrationDatabaseName.unwrap(value): java.lang.String
        )
      )(_.databaseName)
      .optionallyWith(
        partnerName.map(value =>
          PartnerIntegrationPartnerName.unwrap(value): java.lang.String
        )
      )(_.partnerName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          PartnerIntegrationStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(createdAt.map(value => TStamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => TStamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.PartnerIntegrationInfo.ReadOnly =
    zio.aws.redshift.model.PartnerIntegrationInfo.wrap(buildAwsValue())
}
object PartnerIntegrationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.PartnerIntegrationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.PartnerIntegrationInfo =
      zio.aws.redshift.model.PartnerIntegrationInfo(
        databaseName.map(value => value),
        partnerName.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value)
      )
    def databaseName: Optional[PartnerIntegrationDatabaseName]
    def partnerName: Optional[PartnerIntegrationPartnerName]
    def status: Optional[zio.aws.redshift.model.PartnerIntegrationStatus]
    def statusMessage: Optional[PartnerIntegrationStatusMessage]
    def createdAt: Optional[TStamp]
    def updatedAt: Optional[TStamp]
    def getDatabaseName: ZIO[Any, AwsError, PartnerIntegrationDatabaseName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getPartnerName: ZIO[Any, AwsError, PartnerIntegrationPartnerName] =
      AwsError.unwrapOptionField("partnerName", partnerName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.PartnerIntegrationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, PartnerIntegrationStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreatedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.PartnerIntegrationInfo
  ) extends zio.aws.redshift.model.PartnerIntegrationInfo.ReadOnly {
    override val databaseName: Optional[PartnerIntegrationDatabaseName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseName())
        .map(value =>
          zio.aws.redshift.model.primitives
            .PartnerIntegrationDatabaseName(value)
        )
    override val partnerName: Optional[PartnerIntegrationPartnerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partnerName())
        .map(value =>
          zio.aws.redshift.model.primitives.PartnerIntegrationPartnerName(value)
        )
    override val status
        : Optional[zio.aws.redshift.model.PartnerIntegrationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.redshift.model.PartnerIntegrationStatus.wrap(value)
        )
    override val statusMessage: Optional[PartnerIntegrationStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.redshift.model.primitives
            .PartnerIntegrationStatusMessage(value)
        )
    override val createdAt: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val updatedAt: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.PartnerIntegrationInfo
  ): zio.aws.redshift.model.PartnerIntegrationInfo.ReadOnly = new Wrapper(impl)
}
