package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class RevisionTarget(
    databaseRevision: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    databaseRevisionReleaseDate: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RevisionTarget = {
    import RevisionTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RevisionTarget
      .builder()
      .optionallyWith(databaseRevision.map(value => value: java.lang.String))(
        _.databaseRevision
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        databaseRevisionReleaseDate.map(value => TStamp.unwrap(value): Instant)
      )(_.databaseRevisionReleaseDate)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.RevisionTarget.ReadOnly =
    zio.aws.redshift.model.RevisionTarget.wrap(buildAwsValue())
}
object RevisionTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RevisionTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.RevisionTarget =
      zio.aws.redshift.model.RevisionTarget(
        databaseRevision.map(value => value),
        description.map(value => value),
        databaseRevisionReleaseDate.map(value => value)
      )
    def databaseRevision: Optional[String]
    def description: Optional[String]
    def databaseRevisionReleaseDate: Optional[TStamp]
    def getDatabaseRevision: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseRevision", databaseRevision)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDatabaseRevisionReleaseDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "databaseRevisionReleaseDate",
        databaseRevisionReleaseDate
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RevisionTarget
  ) extends zio.aws.redshift.model.RevisionTarget.ReadOnly {
    override val databaseRevision: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseRevision())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val databaseRevisionReleaseDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseRevisionReleaseDate())
        .map(value => zio.aws.redshift.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RevisionTarget
  ): zio.aws.redshift.model.RevisionTarget.ReadOnly = new Wrapper(impl)
}
