package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SnapshotErrorMessage(
    snapshotIdentifier: Optional[String] = Optional.Absent,
    snapshotClusterIdentifier: Optional[String] = Optional.Absent,
    failureCode: Optional[String] = Optional.Absent,
    failureReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.SnapshotErrorMessage = {
    import SnapshotErrorMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.SnapshotErrorMessage
      .builder()
      .optionallyWith(snapshotIdentifier.map(value => value: java.lang.String))(
        _.snapshotIdentifier
      )
      .optionallyWith(
        snapshotClusterIdentifier.map(value => value: java.lang.String)
      )(_.snapshotClusterIdentifier)
      .optionallyWith(failureCode.map(value => value: java.lang.String))(
        _.failureCode
      )
      .optionallyWith(failureReason.map(value => value: java.lang.String))(
        _.failureReason
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.SnapshotErrorMessage.ReadOnly =
    zio.aws.redshift.model.SnapshotErrorMessage.wrap(buildAwsValue())
}
object SnapshotErrorMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.SnapshotErrorMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.SnapshotErrorMessage =
      zio.aws.redshift.model.SnapshotErrorMessage(
        snapshotIdentifier.map(value => value),
        snapshotClusterIdentifier.map(value => value),
        failureCode.map(value => value),
        failureReason.map(value => value)
      )
    def snapshotIdentifier: Optional[String]
    def snapshotClusterIdentifier: Optional[String]
    def failureCode: Optional[String]
    def failureReason: Optional[String]
    def getSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotIdentifier", snapshotIdentifier)
    def getSnapshotClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("snapshotClusterIdentifier", snapshotClusterIdentifier)
    def getFailureCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.SnapshotErrorMessage
  ) extends zio.aws.redshift.model.SnapshotErrorMessage.ReadOnly {
    override val snapshotIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotIdentifier())
      .map(value => value: String)
    override val snapshotClusterIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotClusterIdentifier())
        .map(value => value: String)
    override val failureCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureCode())
      .map(value => value: String)
    override val failureReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.SnapshotErrorMessage
  ): zio.aws.redshift.model.SnapshotErrorMessage.ReadOnly = new Wrapper(impl)
}
