package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SnapshotSortingEntity(
    attribute: zio.aws.redshift.model.SnapshotAttributeToSortBy,
    sortOrder: Optional[zio.aws.redshift.model.SortByOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.SnapshotSortingEntity = {
    import SnapshotSortingEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.SnapshotSortingEntity
      .builder()
      .attribute(attribute.unwrap)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.SnapshotSortingEntity.ReadOnly =
    zio.aws.redshift.model.SnapshotSortingEntity.wrap(buildAwsValue())
}
object SnapshotSortingEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.SnapshotSortingEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.SnapshotSortingEntity =
      zio.aws.redshift.model
        .SnapshotSortingEntity(attribute, sortOrder.map(value => value))
    def attribute: zio.aws.redshift.model.SnapshotAttributeToSortBy
    def sortOrder: Optional[zio.aws.redshift.model.SortByOrder]
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.redshift.model.SnapshotAttributeToSortBy] =
      ZIO.succeed(attribute)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.redshift.model.SortByOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.SnapshotSortingEntity
  ) extends zio.aws.redshift.model.SnapshotSortingEntity.ReadOnly {
    override val attribute: zio.aws.redshift.model.SnapshotAttributeToSortBy =
      zio.aws.redshift.model.SnapshotAttributeToSortBy.wrap(impl.attribute())
    override val sortOrder: Optional[zio.aws.redshift.model.SortByOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.redshift.model.SortByOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.SnapshotSortingEntity
  ): zio.aws.redshift.model.SnapshotSortingEntity.ReadOnly = new Wrapper(impl)
}
