package zio.aws.redshift.model
import scala.jdk.CollectionConverters._
sealed trait SortByOrder {
  def unwrap: software.amazon.awssdk.services.redshift.model.SortByOrder
}
object SortByOrder {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.SortByOrder
  ): zio.aws.redshift.model.SortByOrder = value match {
    case software.amazon.awssdk.services.redshift.model.SortByOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.SortByOrder.ASC =>
      val r = ASC
      r
    case software.amazon.awssdk.services.redshift.model.SortByOrder.DESC =>
      val r = DESC
      r
  }
  case object unknownToSdkVersion extends zio.aws.redshift.model.SortByOrder {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.SortByOrder =
      software.amazon.awssdk.services.redshift.model.SortByOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object ASC extends zio.aws.redshift.model.SortByOrder {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.SortByOrder =
      software.amazon.awssdk.services.redshift.model.SortByOrder.ASC
  }
  case object DESC extends zio.aws.redshift.model.SortByOrder {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.SortByOrder =
      software.amazon.awssdk.services.redshift.model.SortByOrder.DESC
  }
}
