package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SupportedPlatform(name: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.SupportedPlatform = {
    import SupportedPlatform.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.SupportedPlatform
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.SupportedPlatform.ReadOnly =
    zio.aws.redshift.model.SupportedPlatform.wrap(buildAwsValue())
}
object SupportedPlatform {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.SupportedPlatform
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.SupportedPlatform =
      zio.aws.redshift.model.SupportedPlatform(name.map(value => value))
    def name: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.SupportedPlatform
  ) extends zio.aws.redshift.model.SupportedPlatform.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.SupportedPlatform
  ): zio.aws.redshift.model.SupportedPlatform.ReadOnly = new Wrapper(impl)
}
