package zio.aws.redshift.model
import scala.jdk.CollectionConverters._
sealed trait TableRestoreStatusType {
  def unwrap
      : software.amazon.awssdk.services.redshift.model.TableRestoreStatusType
}
object TableRestoreStatusType {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.TableRestoreStatusType
  ): zio.aws.redshift.model.TableRestoreStatusType = value match {
    case software.amazon.awssdk.services.redshift.model.TableRestoreStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.TableRestoreStatusType.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.redshift.model.TableRestoreStatusType.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.redshift.model.TableRestoreStatusType.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.redshift.model.TableRestoreStatusType.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.redshift.model.TableRestoreStatusType.CANCELED =>
      val r = CANCELED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.TableRestoreStatusType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.TableRestoreStatusType =
      software.amazon.awssdk.services.redshift.model.TableRestoreStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.redshift.model.TableRestoreStatusType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.TableRestoreStatusType =
      software.amazon.awssdk.services.redshift.model.TableRestoreStatusType.PENDING
  }
  case object IN_PROGRESS
      extends zio.aws.redshift.model.TableRestoreStatusType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.TableRestoreStatusType =
      software.amazon.awssdk.services.redshift.model.TableRestoreStatusType.IN_PROGRESS
  }
  case object SUCCEEDED extends zio.aws.redshift.model.TableRestoreStatusType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.TableRestoreStatusType =
      software.amazon.awssdk.services.redshift.model.TableRestoreStatusType.SUCCEEDED
  }
  case object FAILED extends zio.aws.redshift.model.TableRestoreStatusType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.TableRestoreStatusType =
      software.amazon.awssdk.services.redshift.model.TableRestoreStatusType.FAILED
  }
  case object CANCELED extends zio.aws.redshift.model.TableRestoreStatusType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.TableRestoreStatusType =
      software.amazon.awssdk.services.redshift.model.TableRestoreStatusType.CANCELED
  }
}
