package zio.aws.redshift.model
import scala.jdk.CollectionConverters._
sealed trait UsageLimitPeriod {
  def unwrap: software.amazon.awssdk.services.redshift.model.UsageLimitPeriod
}
object UsageLimitPeriod {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.UsageLimitPeriod
  ): zio.aws.redshift.model.UsageLimitPeriod = value match {
    case software.amazon.awssdk.services.redshift.model.UsageLimitPeriod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.UsageLimitPeriod.DAILY =>
      val r = daily
      r
    case software.amazon.awssdk.services.redshift.model.UsageLimitPeriod.WEEKLY =>
      val r = weekly
      r
    case software.amazon.awssdk.services.redshift.model.UsageLimitPeriod.MONTHLY =>
      val r = monthly
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.UsageLimitPeriod {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.UsageLimitPeriod =
      software.amazon.awssdk.services.redshift.model.UsageLimitPeriod.UNKNOWN_TO_SDK_VERSION
  }
  case object daily extends zio.aws.redshift.model.UsageLimitPeriod {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.UsageLimitPeriod =
      software.amazon.awssdk.services.redshift.model.UsageLimitPeriod.DAILY
  }
  case object weekly extends zio.aws.redshift.model.UsageLimitPeriod {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.UsageLimitPeriod =
      software.amazon.awssdk.services.redshift.model.UsageLimitPeriod.WEEKLY
  }
  case object monthly extends zio.aws.redshift.model.UsageLimitPeriod {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.UsageLimitPeriod =
      software.amazon.awssdk.services.redshift.model.UsageLimitPeriod.MONTHLY
  }
}
