package zio.aws.redshiftdata.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftdata.model.primitives.{
  WorkgroupNameString,
  SecretArn,
  PageSize,
  Location
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeTableRequest(
    clusterIdentifier: Optional[Location] = Optional.Absent,
    connectedDatabase: Optional[String] = Optional.Absent,
    database: String,
    dbUser: Optional[String] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    schema: Optional[String] = Optional.Absent,
    secretArn: Optional[SecretArn] = Optional.Absent,
    table: Optional[String] = Optional.Absent,
    workgroupName: Optional[WorkgroupNameString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest = {
    import DescribeTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest
      .builder()
      .optionallyWith(
        clusterIdentifier.map(value => Location.unwrap(value): java.lang.String)
      )(_.clusterIdentifier)
      .optionallyWith(connectedDatabase.map(value => value: java.lang.String))(
        _.connectedDatabase
      )
      .database(database: java.lang.String)
      .optionallyWith(dbUser.map(value => value: java.lang.String))(_.dbUser)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(schema.map(value => value: java.lang.String))(_.schema)
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .optionallyWith(table.map(value => value: java.lang.String))(_.table)
      .optionallyWith(
        workgroupName.map(value =>
          WorkgroupNameString.unwrap(value): java.lang.String
        )
      )(_.workgroupName)
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.DescribeTableRequest.ReadOnly =
    zio.aws.redshiftdata.model.DescribeTableRequest.wrap(buildAwsValue())
}
object DescribeTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.DescribeTableRequest =
      zio.aws.redshiftdata.model.DescribeTableRequest(
        clusterIdentifier.map(value => value),
        connectedDatabase.map(value => value),
        database,
        dbUser.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        schema.map(value => value),
        secretArn.map(value => value),
        table.map(value => value),
        workgroupName.map(value => value)
      )
    def clusterIdentifier: Optional[Location]
    def connectedDatabase: Optional[String]
    def database: String
    def dbUser: Optional[String]
    def maxResults: Optional[PageSize]
    def nextToken: Optional[String]
    def schema: Optional[String]
    def secretArn: Optional[SecretArn]
    def table: Optional[String]
    def workgroupName: Optional[WorkgroupNameString]
    def getClusterIdentifier: ZIO[Any, AwsError, Location] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getConnectedDatabase: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectedDatabase", connectedDatabase)
    def getDatabase: ZIO[Any, Nothing, String] = ZIO.succeed(database)
    def getDbUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSchema: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schema", schema)
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
    def getTable: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("table", table)
    def getWorkgroupName: ZIO[Any, AwsError, WorkgroupNameString] =
      AwsError.unwrapOptionField("workgroupName", workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest
  ) extends zio.aws.redshiftdata.model.DescribeTableRequest.ReadOnly {
    override val clusterIdentifier: Optional[Location] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => zio.aws.redshiftdata.model.primitives.Location(value))
    override val connectedDatabase: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.connectedDatabase())
      .map(value => value: String)
    override val database: String = impl.database(): String
    override val dbUser: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbUser())
      .map(value => value: String)
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.redshiftdata.model.primitives.PageSize(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val schema: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value => value: String)
    override val secretArn: Optional[SecretArn] = zio.aws.core.internal
      .optionalFromNullable(impl.secretArn())
      .map(value => zio.aws.redshiftdata.model.primitives.SecretArn(value))
    override val table: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.table())
      .map(value => value: String)
    override val workgroupName: Optional[WorkgroupNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workgroupName())
        .map(value =>
          zio.aws.redshiftdata.model.primitives.WorkgroupNameString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest
  ): zio.aws.redshiftdata.model.DescribeTableRequest.ReadOnly = new Wrapper(
    impl
  )
}
