package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeTableResponse(
    columnList: Optional[Iterable[zio.aws.redshiftdata.model.ColumnMetadata]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    tableName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse = {
    import DescribeTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse
      .builder()
      .optionallyWith(
        columnList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.columnList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(tableName.map(value => value: java.lang.String))(
        _.tableName
      )
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.DescribeTableResponse.ReadOnly =
    zio.aws.redshiftdata.model.DescribeTableResponse.wrap(buildAwsValue())
}
object DescribeTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.DescribeTableResponse =
      zio.aws.redshiftdata.model.DescribeTableResponse(
        columnList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        tableName.map(value => value)
      )
    def columnList
        : Optional[List[zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly]]
    def nextToken: Optional[String]
    def tableName: Optional[String]
    def getColumnList: ZIO[Any, AwsError, List[
      zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("columnList", columnList)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableName", tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse
  ) extends zio.aws.redshiftdata.model.DescribeTableResponse.ReadOnly {
    override val columnList
        : Optional[List[zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.columnList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftdata.model.ColumnMetadata.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val tableName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse
  ): zio.aws.redshiftdata.model.DescribeTableResponse.ReadOnly = new Wrapper(
    impl
  )
}
