package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDatabasesResponse(
    databases: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.ListDatabasesResponse = {
    import ListDatabasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.ListDatabasesResponse
      .builder()
      .optionallyWith(
        databases.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.databases)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.ListDatabasesResponse.ReadOnly =
    zio.aws.redshiftdata.model.ListDatabasesResponse.wrap(buildAwsValue())
}
object ListDatabasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.ListDatabasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.ListDatabasesResponse =
      zio.aws.redshiftdata.model.ListDatabasesResponse(
        databases.map(value => value),
        nextToken.map(value => value)
      )
    def databases: Optional[List[String]]
    def nextToken: Optional[String]
    def getDatabases: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("databases", databases)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListDatabasesResponse
  ) extends zio.aws.redshiftdata.model.ListDatabasesResponse.ReadOnly {
    override val databases: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.databases())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListDatabasesResponse
  ): zio.aws.redshiftdata.model.ListDatabasesResponse.ReadOnly = new Wrapper(
    impl
  )
}
