package zio.aws.redshiftdata.model
import scala.jdk.CollectionConverters.*
sealed trait StatusString {
  def unwrap: software.amazon.awssdk.services.redshiftdata.model.StatusString
}
object StatusString {
  def wrap(
      value: software.amazon.awssdk.services.redshiftdata.model.StatusString
  ): zio.aws.redshiftdata.model.StatusString = value match {
    case software.amazon.awssdk.services.redshiftdata.model.StatusString.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshiftdata.model.StatusString.SUBMITTED =>
      val r = SUBMITTED
      r
    case software.amazon.awssdk.services.redshiftdata.model.StatusString.PICKED =>
      val r = PICKED
      r
    case software.amazon.awssdk.services.redshiftdata.model.StatusString.STARTED =>
      val r = STARTED
      r
    case software.amazon.awssdk.services.redshiftdata.model.StatusString.FINISHED =>
      val r = FINISHED
      r
    case software.amazon.awssdk.services.redshiftdata.model.StatusString.ABORTED =>
      val r = ABORTED
      r
    case software.amazon.awssdk.services.redshiftdata.model.StatusString.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.redshiftdata.model.StatusString.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshiftdata.model.StatusString {
    override def unwrap
        : software.amazon.awssdk.services.redshiftdata.model.StatusString =
      software.amazon.awssdk.services.redshiftdata.model.StatusString.UNKNOWN_TO_SDK_VERSION
  }
  case object SUBMITTED extends zio.aws.redshiftdata.model.StatusString {
    override def unwrap
        : software.amazon.awssdk.services.redshiftdata.model.StatusString =
      software.amazon.awssdk.services.redshiftdata.model.StatusString.SUBMITTED
  }
  case object PICKED extends zio.aws.redshiftdata.model.StatusString {
    override def unwrap
        : software.amazon.awssdk.services.redshiftdata.model.StatusString =
      software.amazon.awssdk.services.redshiftdata.model.StatusString.PICKED
  }
  case object STARTED extends zio.aws.redshiftdata.model.StatusString {
    override def unwrap
        : software.amazon.awssdk.services.redshiftdata.model.StatusString =
      software.amazon.awssdk.services.redshiftdata.model.StatusString.STARTED
  }
  case object FINISHED extends zio.aws.redshiftdata.model.StatusString {
    override def unwrap
        : software.amazon.awssdk.services.redshiftdata.model.StatusString =
      software.amazon.awssdk.services.redshiftdata.model.StatusString.FINISHED
  }
  case object ABORTED extends zio.aws.redshiftdata.model.StatusString {
    override def unwrap
        : software.amazon.awssdk.services.redshiftdata.model.StatusString =
      software.amazon.awssdk.services.redshiftdata.model.StatusString.ABORTED
  }
  case object FAILED extends zio.aws.redshiftdata.model.StatusString {
    override def unwrap
        : software.amazon.awssdk.services.redshiftdata.model.StatusString =
      software.amazon.awssdk.services.redshiftdata.model.StatusString.FAILED
  }
  case object ALL extends zio.aws.redshiftdata.model.StatusString {
    override def unwrap
        : software.amazon.awssdk.services.redshiftdata.model.StatusString =
      software.amazon.awssdk.services.redshiftdata.model.StatusString.ALL
  }
}
