package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class BatchDeleteWorldsResponse(
    unprocessedWorlds: Option[Iterable[Arn]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsResponse = {
    import BatchDeleteWorldsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsResponse
      .builder()
      .optionallyWith(
        unprocessedWorlds.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.unprocessedWorlds)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.BatchDeleteWorldsResponse.ReadOnly =
    zio.aws.robomaker.model.BatchDeleteWorldsResponse.wrap(buildAwsValue())
}
object BatchDeleteWorldsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.BatchDeleteWorldsResponse =
      zio.aws.robomaker.model
        .BatchDeleteWorldsResponse(unprocessedWorlds.map(value => value))
    def unprocessedWorlds: Option[List[Arn]]
    def getUnprocessedWorlds: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("unprocessedWorlds", unprocessedWorlds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsResponse
  ) extends zio.aws.robomaker.model.BatchDeleteWorldsResponse.ReadOnly {
    override val unprocessedWorlds: Option[List[Arn]] = scala
      .Option(impl.unprocessedWorlds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.Arn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsResponse
  ): zio.aws.robomaker.model.BatchDeleteWorldsResponse.ReadOnly = new Wrapper(
    impl
  )
}
