package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class CancelSimulationJobBatchRequest(batch: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CancelSimulationJobBatchRequest = {
    import CancelSimulationJobBatchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CancelSimulationJobBatchRequest
      .builder()
      .batch(Arn.unwrap(batch): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.CancelSimulationJobBatchRequest.ReadOnly =
    zio.aws.robomaker.model.CancelSimulationJobBatchRequest
      .wrap(buildAwsValue())
}
object CancelSimulationJobBatchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CancelSimulationJobBatchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CancelSimulationJobBatchRequest =
      zio.aws.robomaker.model.CancelSimulationJobBatchRequest(batch)
    def batch: Arn
    def getBatch: ZIO[Any, Nothing, Arn] = ZIO.succeed(batch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CancelSimulationJobBatchRequest
  ) extends zio.aws.robomaker.model.CancelSimulationJobBatchRequest.ReadOnly {
    override val batch: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.batch())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CancelSimulationJobBatchRequest
  ): zio.aws.robomaker.model.CancelSimulationJobBatchRequest.ReadOnly =
    new Wrapper(impl)
}
