package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class CancelWorldExportJobRequest(job: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CancelWorldExportJobRequest = {
    import CancelWorldExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CancelWorldExportJobRequest
      .builder()
      .job(Arn.unwrap(job): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.CancelWorldExportJobRequest.ReadOnly =
    zio.aws.robomaker.model.CancelWorldExportJobRequest.wrap(buildAwsValue())
}
object CancelWorldExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CancelWorldExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CancelWorldExportJobRequest =
      zio.aws.robomaker.model.CancelWorldExportJobRequest(job)
    def job: Arn
    def getJob: ZIO[Any, Nothing, Arn] = ZIO.succeed(job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CancelWorldExportJobRequest
  ) extends zio.aws.robomaker.model.CancelWorldExportJobRequest.ReadOnly {
    override val job: Arn = zio.aws.robomaker.model.primitives.Arn(impl.job())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CancelWorldExportJobRequest
  ): zio.aws.robomaker.model.CancelWorldExportJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
