package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{
  TagValue,
  TagKey,
  Arn,
  ClientRequestToken
}
import scala.jdk.CollectionConverters._
final case class CreateDeploymentJobRequest(
    deploymentConfig: Option[zio.aws.robomaker.model.DeploymentConfig] = None,
    clientRequestToken: ClientRequestToken,
    fleet: Arn,
    deploymentApplicationConfigs: Iterable[
      zio.aws.robomaker.model.DeploymentApplicationConfig
    ],
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobRequest = {
    import CreateDeploymentJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobRequest
      .builder()
      .optionallyWith(deploymentConfig.map(value => value.buildAwsValue()))(
        _.deploymentConfig
      )
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .fleet(Arn.unwrap(fleet): java.lang.String)
      .deploymentApplicationConfigs(deploymentApplicationConfigs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.CreateDeploymentJobRequest.ReadOnly =
    zio.aws.robomaker.model.CreateDeploymentJobRequest.wrap(buildAwsValue())
}
object CreateDeploymentJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateDeploymentJobRequest =
      zio.aws.robomaker.model.CreateDeploymentJobRequest(
        deploymentConfig.map(value => value.asEditable),
        clientRequestToken,
        fleet,
        deploymentApplicationConfigs.map { item =>
          item.asEditable
        },
        tags.map(value => value)
      )
    def deploymentConfig
        : Option[zio.aws.robomaker.model.DeploymentConfig.ReadOnly]
    def clientRequestToken: ClientRequestToken
    def fleet: Arn
    def deploymentApplicationConfigs
        : List[zio.aws.robomaker.model.DeploymentApplicationConfig.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getDeploymentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.DeploymentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentConfig", deploymentConfig)
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
    def getFleet: ZIO[Any, Nothing, Arn] = ZIO.succeed(fleet)
    def getDeploymentApplicationConfigs: ZIO[Any, Nothing, List[
      zio.aws.robomaker.model.DeploymentApplicationConfig.ReadOnly
    ]] = ZIO.succeed(deploymentApplicationConfigs)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobRequest
  ) extends zio.aws.robomaker.model.CreateDeploymentJobRequest.ReadOnly {
    override val deploymentConfig
        : Option[zio.aws.robomaker.model.DeploymentConfig.ReadOnly] = scala
      .Option(impl.deploymentConfig())
      .map(value => zio.aws.robomaker.model.DeploymentConfig.wrap(value))
    override val clientRequestToken: ClientRequestToken =
      zio.aws.robomaker.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
    override val fleet: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.fleet())
    override val deploymentApplicationConfigs
        : List[zio.aws.robomaker.model.DeploymentApplicationConfig.ReadOnly] =
      impl
        .deploymentApplicationConfigs()
        .asScala
        .map { item =>
          zio.aws.robomaker.model.DeploymentApplicationConfig.wrap(item)
        }
        .toList
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobRequest
  ): zio.aws.robomaker.model.CreateDeploymentJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
