package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{TagValue, TagKey, Id, Name}
import scala.jdk.CollectionConverters._
final case class CreateRobotRequest(
    name: Name,
    architecture: zio.aws.robomaker.model.Architecture,
    greengrassGroupId: Id,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateRobotRequest = {
    import CreateRobotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateRobotRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .architecture(architecture.unwrap)
      .greengrassGroupId(Id.unwrap(greengrassGroupId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.CreateRobotRequest.ReadOnly =
    zio.aws.robomaker.model.CreateRobotRequest.wrap(buildAwsValue())
}
object CreateRobotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateRobotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateRobotRequest =
      zio.aws.robomaker.model.CreateRobotRequest(
        name,
        architecture,
        greengrassGroupId,
        tags.map(value => value)
      )
    def name: Name
    def architecture: zio.aws.robomaker.model.Architecture
    def greengrassGroupId: Id
    def tags: Option[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getArchitecture
        : ZIO[Any, Nothing, zio.aws.robomaker.model.Architecture] =
      ZIO.succeed(architecture)
    def getGreengrassGroupId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(greengrassGroupId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateRobotRequest
  ) extends zio.aws.robomaker.model.CreateRobotRequest.ReadOnly {
    override val name: Name =
      zio.aws.robomaker.model.primitives.Name(impl.name())
    override val architecture: zio.aws.robomaker.model.Architecture =
      zio.aws.robomaker.model.Architecture.wrap(impl.architecture())
    override val greengrassGroupId: Id =
      zio.aws.robomaker.model.primitives.Id(impl.greengrassGroupId())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateRobotRequest
  ): zio.aws.robomaker.model.CreateRobotRequest.ReadOnly = new Wrapper(impl)
}
