package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class DeleteFleetRequest(fleet: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DeleteFleetRequest = {
    import DeleteFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DeleteFleetRequest
      .builder()
      .fleet(Arn.unwrap(fleet): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DeleteFleetRequest.ReadOnly =
    zio.aws.robomaker.model.DeleteFleetRequest.wrap(buildAwsValue())
}
object DeleteFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DeleteFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DeleteFleetRequest =
      zio.aws.robomaker.model.DeleteFleetRequest(fleet)
    def fleet: Arn
    def getFleet: ZIO[Any, Nothing, Arn] = ZIO.succeed(fleet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DeleteFleetRequest
  ) extends zio.aws.robomaker.model.DeleteFleetRequest.ReadOnly {
    override val fleet: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.fleet())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DeleteFleetRequest
  ): zio.aws.robomaker.model.DeleteFleetRequest.ReadOnly = new Wrapper(impl)
}
