package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.{DeploymentVersion, Arn}
import scala.jdk.CollectionConverters._
final case class DeploymentApplicationConfig(
    application: Arn,
    applicationVersion: DeploymentVersion,
    launchConfig: zio.aws.robomaker.model.DeploymentLaunchConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DeploymentApplicationConfig = {
    import DeploymentApplicationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DeploymentApplicationConfig
      .builder()
      .application(Arn.unwrap(application): java.lang.String)
      .applicationVersion(
        DeploymentVersion.unwrap(applicationVersion): java.lang.String
      )
      .launchConfig(launchConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DeploymentApplicationConfig.ReadOnly =
    zio.aws.robomaker.model.DeploymentApplicationConfig.wrap(buildAwsValue())
}
object DeploymentApplicationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DeploymentApplicationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DeploymentApplicationConfig =
      zio.aws.robomaker.model.DeploymentApplicationConfig(
        application,
        applicationVersion,
        launchConfig.asEditable
      )
    def application: Arn
    def applicationVersion: DeploymentVersion
    def launchConfig: zio.aws.robomaker.model.DeploymentLaunchConfig.ReadOnly
    def getApplication: ZIO[Any, Nothing, Arn] = ZIO.succeed(application)
    def getApplicationVersion: ZIO[Any, Nothing, DeploymentVersion] =
      ZIO.succeed(applicationVersion)
    def getLaunchConfig: ZIO[
      Any,
      Nothing,
      zio.aws.robomaker.model.DeploymentLaunchConfig.ReadOnly
    ] = ZIO.succeed(launchConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DeploymentApplicationConfig
  ) extends zio.aws.robomaker.model.DeploymentApplicationConfig.ReadOnly {
    override val application: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.application())
    override val applicationVersion: DeploymentVersion =
      zio.aws.robomaker.model.primitives
        .DeploymentVersion(impl.applicationVersion())
    override val launchConfig
        : zio.aws.robomaker.model.DeploymentLaunchConfig.ReadOnly =
      zio.aws.robomaker.model.DeploymentLaunchConfig.wrap(impl.launchConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DeploymentApplicationConfig
  ): zio.aws.robomaker.model.DeploymentApplicationConfig.ReadOnly = new Wrapper(
    impl
  )
}
