package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.robomaker.model.primitives.{
  CreatedAt,
  GenericString,
  ClientRequestToken,
  TagValue,
  Arn,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class DescribeWorldGenerationJobResponse(
    arn: Option[Arn] = None,
    status: Option[zio.aws.robomaker.model.WorldGenerationJobStatus] = None,
    createdAt: Option[CreatedAt] = None,
    failureCode: Option[zio.aws.robomaker.model.WorldGenerationJobErrorCode] =
      None,
    failureReason: Option[GenericString] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    template: Option[Arn] = None,
    worldCount: Option[zio.aws.robomaker.model.WorldCount] = None,
    finishedWorldsSummary: Option[
      zio.aws.robomaker.model.FinishedWorldsSummary
    ] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    worldTags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobResponse = {
    import DescribeWorldGenerationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(
        failureReason.map(value =>
          GenericString.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        template.map(value => Arn.unwrap(value): java.lang.String)
      )(_.template)
      .optionallyWith(worldCount.map(value => value.buildAwsValue()))(
        _.worldCount
      )
      .optionallyWith(
        finishedWorldsSummary.map(value => value.buildAwsValue())
      )(_.finishedWorldsSummary)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        worldTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.worldTags)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.DescribeWorldGenerationJobResponse.ReadOnly =
    zio.aws.robomaker.model.DescribeWorldGenerationJobResponse
      .wrap(buildAwsValue())
}
object DescribeWorldGenerationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeWorldGenerationJobResponse =
      zio.aws.robomaker.model.DescribeWorldGenerationJobResponse(
        arn.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        failureCode.map(value => value),
        failureReason.map(value => value),
        clientRequestToken.map(value => value),
        template.map(value => value),
        worldCount.map(value => value.asEditable),
        finishedWorldsSummary.map(value => value.asEditable),
        tags.map(value => value),
        worldTags.map(value => value)
      )
    def arn: Option[Arn]
    def status: Option[zio.aws.robomaker.model.WorldGenerationJobStatus]
    def createdAt: Option[CreatedAt]
    def failureCode: Option[zio.aws.robomaker.model.WorldGenerationJobErrorCode]
    def failureReason: Option[GenericString]
    def clientRequestToken: Option[ClientRequestToken]
    def template: Option[Arn]
    def worldCount: Option[zio.aws.robomaker.model.WorldCount.ReadOnly]
    def finishedWorldsSummary
        : Option[zio.aws.robomaker.model.FinishedWorldsSummary.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def worldTags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.WorldGenerationJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getFailureCode: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.WorldGenerationJobErrorCode
    ] = AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureReason: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTemplate: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("template", template)
    def getWorldCount
        : ZIO[Any, AwsError, zio.aws.robomaker.model.WorldCount.ReadOnly] =
      AwsError.unwrapOptionField("worldCount", worldCount)
    def getFinishedWorldsSummary: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.FinishedWorldsSummary.ReadOnly
    ] =
      AwsError.unwrapOptionField("finishedWorldsSummary", finishedWorldsSummary)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorldTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("worldTags", worldTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobResponse
  ) extends zio.aws.robomaker.model.DescribeWorldGenerationJobResponse.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val status
        : Option[zio.aws.robomaker.model.WorldGenerationJobStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.robomaker.model.WorldGenerationJobStatus.wrap(value)
      )
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val failureCode
        : Option[zio.aws.robomaker.model.WorldGenerationJobErrorCode] = scala
      .Option(impl.failureCode())
      .map(value =>
        zio.aws.robomaker.model.WorldGenerationJobErrorCode.wrap(value)
      )
    override val failureReason: Option[GenericString] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.robomaker.model.primitives.GenericString(value))
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.robomaker.model.primitives.ClientRequestToken(value)
      )
    override val template: Option[Arn] = scala
      .Option(impl.template())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val worldCount
        : Option[zio.aws.robomaker.model.WorldCount.ReadOnly] = scala
      .Option(impl.worldCount())
      .map(value => zio.aws.robomaker.model.WorldCount.wrap(value))
    override val finishedWorldsSummary
        : Option[zio.aws.robomaker.model.FinishedWorldsSummary.ReadOnly] = scala
      .Option(impl.finishedWorldsSummary())
      .map(value => zio.aws.robomaker.model.FinishedWorldsSummary.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val worldTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.worldTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobResponse
  ): zio.aws.robomaker.model.DescribeWorldGenerationJobResponse.ReadOnly =
    new Wrapper(impl)
}
