package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.RepositoryUrl
import scala.jdk.CollectionConverters._
final case class Environment(uri: Option[RepositoryUrl] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.Environment = {
    import Environment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.Environment
      .builder()
      .optionallyWith(
        uri.map(value => RepositoryUrl.unwrap(value): java.lang.String)
      )(_.uri)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.Environment.ReadOnly =
    zio.aws.robomaker.model.Environment.wrap(buildAwsValue())
}
object Environment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.Environment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.Environment =
      zio.aws.robomaker.model.Environment(uri.map(value => value))
    def uri: Option[RepositoryUrl]
    def getUri: ZIO[Any, AwsError, RepositoryUrl] =
      AwsError.unwrapOptionField("uri", uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.Environment
  ) extends zio.aws.robomaker.model.Environment.ReadOnly {
    override val uri: Option[RepositoryUrl] = scala
      .Option(impl.uri())
      .map(value => zio.aws.robomaker.model.primitives.RepositoryUrl(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.Environment
  ): zio.aws.robomaker.model.Environment.ReadOnly = new Wrapper(impl)
}
