package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.Name
import scala.jdk.CollectionConverters._
final case class Filter(
    name: Option[Name] = None,
    values: Option[Iterable[Name]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.Filter
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.Filter.ReadOnly =
    zio.aws.robomaker.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.robomaker.model.Filter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.Filter = zio.aws.robomaker.model
      .Filter(name.map(value => value), values.map(value => value))
    def name: Option[Name]
    def values: Option[List[Name]]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.Filter
  ) extends zio.aws.robomaker.model.Filter.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val values: Option[List[Name]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.Name(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.Filter
  ): zio.aws.robomaker.model.Filter.ReadOnly = new Wrapper(impl)
}
