package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.{Arn, Integer}
import scala.jdk.CollectionConverters._
final case class FinishedWorldsSummary(
    finishedCount: Option[Integer] = None,
    succeededWorlds: Option[Iterable[Arn]] = None,
    failureSummary: Option[zio.aws.robomaker.model.FailureSummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.FinishedWorldsSummary = {
    import FinishedWorldsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.FinishedWorldsSummary
      .builder()
      .optionallyWith(
        finishedCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.finishedCount)
      .optionallyWith(
        succeededWorlds.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.succeededWorlds)
      .optionallyWith(failureSummary.map(value => value.buildAwsValue()))(
        _.failureSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.FinishedWorldsSummary.ReadOnly =
    zio.aws.robomaker.model.FinishedWorldsSummary.wrap(buildAwsValue())
}
object FinishedWorldsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.FinishedWorldsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.FinishedWorldsSummary =
      zio.aws.robomaker.model.FinishedWorldsSummary(
        finishedCount.map(value => value),
        succeededWorlds.map(value => value),
        failureSummary.map(value => value.asEditable)
      )
    def finishedCount: Option[Integer]
    def succeededWorlds: Option[List[Arn]]
    def failureSummary: Option[zio.aws.robomaker.model.FailureSummary.ReadOnly]
    def getFinishedCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("finishedCount", finishedCount)
    def getSucceededWorlds: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("succeededWorlds", succeededWorlds)
    def getFailureSummary
        : ZIO[Any, AwsError, zio.aws.robomaker.model.FailureSummary.ReadOnly] =
      AwsError.unwrapOptionField("failureSummary", failureSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.FinishedWorldsSummary
  ) extends zio.aws.robomaker.model.FinishedWorldsSummary.ReadOnly {
    override val finishedCount: Option[Integer] = scala
      .Option(impl.finishedCount())
      .map(value => zio.aws.robomaker.model.primitives.Integer(value))
    override val succeededWorlds: Option[List[Arn]] = scala
      .Option(impl.succeededWorlds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.Arn(item)
        }.toList
      )
    override val failureSummary
        : Option[zio.aws.robomaker.model.FailureSummary.ReadOnly] = scala
      .Option(impl.failureSummary())
      .map(value => zio.aws.robomaker.model.FailureSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.FinishedWorldsSummary
  ): zio.aws.robomaker.model.FinishedWorldsSummary.ReadOnly = new Wrapper(impl)
}
