package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListFleetsResponse(
    fleetDetails: Option[Iterable[zio.aws.robomaker.model.Fleet]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ListFleetsResponse = {
    import ListFleetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ListFleetsResponse
      .builder()
      .optionallyWith(
        fleetDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fleetDetails)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.ListFleetsResponse.ReadOnly =
    zio.aws.robomaker.model.ListFleetsResponse.wrap(buildAwsValue())
}
object ListFleetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ListFleetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ListFleetsResponse =
      zio.aws.robomaker.model.ListFleetsResponse(
        fleetDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fleetDetails: Option[List[zio.aws.robomaker.model.Fleet.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getFleetDetails
        : ZIO[Any, AwsError, List[zio.aws.robomaker.model.Fleet.ReadOnly]] =
      AwsError.unwrapOptionField("fleetDetails", fleetDetails)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ListFleetsResponse
  ) extends zio.aws.robomaker.model.ListFleetsResponse.ReadOnly {
    override val fleetDetails
        : Option[List[zio.aws.robomaker.model.Fleet.ReadOnly]] = scala
      .Option(impl.fleetDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.Fleet.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.robomaker.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ListFleetsResponse
  ): zio.aws.robomaker.model.ListFleetsResponse.ReadOnly = new Wrapper(impl)
}
