package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListRobotsResponse(
    robots: Option[Iterable[zio.aws.robomaker.model.Robot]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ListRobotsResponse = {
    import ListRobotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ListRobotsResponse
      .builder()
      .optionallyWith(
        robots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.robots)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.ListRobotsResponse.ReadOnly =
    zio.aws.robomaker.model.ListRobotsResponse.wrap(buildAwsValue())
}
object ListRobotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ListRobotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ListRobotsResponse =
      zio.aws.robomaker.model.ListRobotsResponse(
        robots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def robots: Option[List[zio.aws.robomaker.model.Robot.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getRobots
        : ZIO[Any, AwsError, List[zio.aws.robomaker.model.Robot.ReadOnly]] =
      AwsError.unwrapOptionField("robots", robots)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ListRobotsResponse
  ) extends zio.aws.robomaker.model.ListRobotsResponse.ReadOnly {
    override val robots: Option[List[zio.aws.robomaker.model.Robot.ReadOnly]] =
      scala
        .Option(impl.robots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.Robot.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.robomaker.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ListRobotsResponse
  ): zio.aws.robomaker.model.ListRobotsResponse.ReadOnly = new Wrapper(impl)
}
