package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.robomaker.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListSimulationApplicationsResponse(
    simulationApplicationSummaries: Option[
      Iterable[zio.aws.robomaker.model.SimulationApplicationSummary]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse = {
    import ListSimulationApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse
      .builder()
      .optionallyWith(
        simulationApplicationSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.simulationApplicationSummaries)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.ListSimulationApplicationsResponse.ReadOnly =
    zio.aws.robomaker.model.ListSimulationApplicationsResponse
      .wrap(buildAwsValue())
}
object ListSimulationApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ListSimulationApplicationsResponse =
      zio.aws.robomaker.model.ListSimulationApplicationsResponse(
        simulationApplicationSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def simulationApplicationSummaries: Option[
      List[zio.aws.robomaker.model.SimulationApplicationSummary.ReadOnly]
    ]
    def nextToken: Option[PaginationToken]
    def getSimulationApplicationSummaries: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SimulationApplicationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "simulationApplicationSummaries",
      simulationApplicationSummaries
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse
  ) extends zio.aws.robomaker.model.ListSimulationApplicationsResponse.ReadOnly {
    override val simulationApplicationSummaries: Option[
      List[zio.aws.robomaker.model.SimulationApplicationSummary.ReadOnly]
    ] = scala
      .Option(impl.simulationApplicationSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.SimulationApplicationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.robomaker.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse
  ): zio.aws.robomaker.model.ListSimulationApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
